#include "mbed.h"
#include "mcp3008.h"

#define SPI_CLOCK   (1312500)

Serial pc(USBTX, USBRX); // tx, rx

//SPI (PinName mosi, PinName miso, PinName sclk, PinName ssel=NC)
SPI spiM(D4, D5, D3);
MCP3008 mcp3008_0(&spiM, D6);


int main()
{
    pc.baud(115200);
    spiM.frequency(SPI_CLOCK);
    
    uint16_t v0[8];

    for (;;) {
        for (int i = 0; i < 8; i++) {
            v0[i] = mcp3008_0.read_input_u16(i);
        }        
        
        for (int i = 0; i < 8; i++) {
            pc.printf("%4d\t", v0[i]);
        }             
        pc.printf("\r\n");
        
        wait(0.2);
    }
}
 