#include "mbed.h"
#include "Adafruit_SSD1306.h"

class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};


I2CPreInit gI2C(PB_9,PB_8);

// an SPI sub-class that provides a constructed default

Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);
Serial pc(USBTX, USBRX);

int main()
{
    int n=0;
    gOled.begin();
    gOled.clearDisplay();
    while (1) {
        gOled.printf("Hola\n");
         gOled.printf("numero %d\n",n);
         n++;
        gOled.display();
        gOled.setTextCursor(0,0);
        wait(1.000);
    }

}