#include "mbed.h"
#include "hcsr04.h"

Serial pc(USBTX, USBRX); // tx, rx
Ticker tickerMideDistancia;
unsigned distancia=1000;;


DigitalIn final1(D10);
DigitalIn final2(D9);
DigitalOut step(D13);
DigitalOut dir(D12);
DigitalOut enable(D11);

enum estados {cerrada, abriendose, cerrandose, abierta};
estados estado;

HCSR04  usensor(D7,D8); //(PinName TrigPin,PinName EchoPin):

void mideDistancia()
{
    usensor.start();
}

void paso(int d)
{
    dir=d;
    step=1;
    wait_us(100);
    step=0;
    wait_us(900);
}

void estadoCerrada()
{
    if(distancia<10) {
        enable=1;
        estado=abriendose;
        pc.printf("Estado Abriendose, distancia %d\n",distancia);
    }
}

void estadoAbriendose()
{
    if((final1==1)&&(distancia<10)) {
        estado=abierta;
        enable=0;
    } else if((final1==1)&&(distancia>=10)) {
        enable=1;
        estado=cerrandose;
    } else {
        paso(1);
        pc.printf("paso\n");
        
    }
}

void estadoCerrandose(){
      if(distancia<10) {
        estado=abriendose;
        enable=1;
    } else if(final2==1) {
        estado=cerrada;
        enable=0;
    } else {
        paso(0);
        pc.printf("paso\n");
    }
}

void estadoAbierta()
{
    if (distancia>=10) {
        enable=1;
        estado=cerrandose;
    }
}

int main()
{
    pc.baud(115200);
    tickerMideDistancia.attach(&mideDistancia, 0.5);
    estado=cerrada;
     pc.printf("Estado cerrada\n");
    while(1) {
        distancia=usensor.get_dist_cm();
        switch ( estado ) {
            case cerrada:
                estadoCerrada();
                break;
            case abriendose:
                estadoAbriendose();
                break;
            case abierta:
                estadoAbierta();
                break;
            case cerrandose:
                estadoCerrandose();
                break;
            default:
                break;
        }
    }
}
