#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
InterruptIn final1(PC_13);
InterruptIn final2(D10);

bool final1Pressed = false;
bool final2Pressed = false;

void final1Irq()
{
    final1Pressed = true;
}

void final2Irq()
{
    final2Pressed = true;
}

int main()
{
    pc.baud(115200);
    final1.rise(&final1Irq);
    final2.rise(&final2Irq);
    while (true) {
        if(final1Pressed) {
            pc.printf("Final1 pulsado\r\n");
            final1Pressed=false;
        }
        if(final2Pressed) {
            pc.printf("Final2 pulsado\r\n");
            final2Pressed=false;
        }
    }
}