#include "mbed.h"

AnalogIn sensorTemp(ADC_TEMP);

enum estados {esperandoPulsacion, esperandoSoltr, esperandoDobleClick} estado;

const float         AVG_SLOPE   = 4.3e-03;
const float         V30         = 1.43;


DigitalOut led(LED1);
DigitalIn  boton(USER_BUTTON);

Timer temporizador;

uint32_t media=0;
float mediaf=0.0;
int contador=0;

float calculaTemp()
{
    float temp = (V30-(media*50.35400390625e-6/contador)) / AVG_SLOPE + 30.0f; //50.35400390625e-6=3.3/65536
    return temp;
}

void fEsperandoPulsacion()
{
    if(boton==0) {
        printf("Presionado\n");
        contador++;
        media+=sensorTemp.read_u16();
        mediaf+=(V30-(sensorTemp.read()*3.3)) / AVG_SLOPE + 30.0f;
        temporizador.reset();
        temporizador.start();
        estado=esperandoSoltr;
    }
}

void fEsperandoSoltr()
{
    if(boton==1) {
        if(temporizador.read()>2.0f) {
            printf("Numero de medidas %d con temperatura media %.2f\n",contador,mediaf/contador);
            media=0;
            mediaf=0.0;
            contador=0;
            estado=esperandoPulsacion;
        } else {
            printf("Esperando doble click\n");
            estado=esperandoDobleClick;
        }
    }
}

void fEsperandoDobleClick()
{
    if(temporizador.read()>0.5f) {
        estado=esperandoPulsacion;
    } else if(boton==0) {
        led=!led;
        estado=esperandoSoltr;
    }
}


int main()
{
    printf("Iniciando\n");
    estado=esperandoPulsacion;

    while(1) {
        switch (estado) {
            case esperandoPulsacion:
                fEsperandoPulsacion();
                break;
            case esperandoSoltr:
                fEsperandoSoltr();
                break;
            case esperandoDobleClick:
                fEsperandoDobleClick();
                break;
            default:
                break;
        }
    }
}
