#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx

DigitalOut dirAMotor(A4);
PwmOut     dirBMotor(A3);
InterruptIn encoderA(A2);

int contador=0;

void encoderAIrq()
{
    contador++;
}

int main()
{
    pc.baud(115200);
    encoderA.rise(&encoderAIrq);  // attach the address of the flip function to the rising edge
    dirAMotor=0;
    while (true) {
        for (float i=0; i<1; i=i+0.01) {
            dirBMotor=i;
            wait(0.100);
        }
        pc.printf("Vueltas: %d\r\n",contador);
        contador=0;
    }
}
