float Moist10HS(AnalogIn moist)
{
    // SUBSTRATE CALIBRATION: You have to convert the voltage to VWC using soil or substrate specific calibration. Decagon has generic calibrations (check the 10HS manual at http://manuals.decagon.com/Manuals/13508_10HS_Web.pdf) or you can determine your own calibration. We used our own calibration for Fafard 1P (peat: perlite, Conrad Fafard, Inc., Agawam, MA)
    float SubCalSlope = 1.1785;
    float SubCalIntercept = -0.4938;
    float value = moist.read(); // lee el puerto analogico y lo muestra de 0-1V
    float VWC = value * (3.3) * SubCalSlope + SubCalIntercept;         // Convert the analog reading (which goes from 0 - 1V) 
    return VWC;
}