
#include "mbed.h"

PwmOut PWM1(PF_8);     // pwm outputs
PwmOut PWM2(PF_7);
DigitalOut led1(LED1);

/* Function prototype */
void motorControl(bool dir, float pwmVal);

int main()
{
    
    led1 = 1;
    wait(1);
    led1 = 0;
    PWM1.write(0);       // Duty cycles are initially zero   
    PWM2.write(0);   
    PWM1.period(0.02f);   // 1 kHz pwm frequency
    PWM2.period(0.02f);
    
    while(1)
    {
        for(float i=0;i<1;i=i+0.01f)  // increase speed from 0 to 1 in 5 seconds (50ms*100). 
        {
            motorControl(1,i);
            wait(0.05f);    
        }  
        for(float i=1;i>0;i=i-0.01f)  // decrease speed from 1 to 0 in 5 seconds (50ms*100).
        {
            motorControl(0,i);
            wait(0.05f);    
        }   
        led1 = 1;
        wait(0.5);
        led1 = 0;
    }    
}

// This is a motor control function which controls the speed and direction of
// a motor. Motor drivers like L293D can be used.
void motorControl(bool dir, float pwmVal)
{
    if(dir==1)               // forward direction
    {
        PWM2.write(0);   
        PWM1.write(pwmVal);        
    }
    else if(dir==0)         // reverse direction
    {     
        PWM1.write(0);       
        PWM2.write(pwmVal);   
    }    
}