#include "mbed.h"
#include "Motor.h"
#include "QEI.h"

QEI encoder1(PE_11, PE_9, NC, 6, QEI::X4_ENCODING);     // (P0, P1, indice, PulsosPorRev, TipoDeEncoder)
Motor motor1(PE_13, PF_15, PG_14);      // (pwm, derecho, inverso)
Serial bt(PE_8, PE_7);                  // RX, TX (serial 5)
Ticker ticker1;                         // iniciamos un ticker
DigitalOut led1(LED1);                  // definimos la salida del LED
int pulsos  = 0;        // numero de pulsos recorridos

void enviar_bt();       // declaramos el prototipo de la funcion que ejecutara el ticker

int main() 
{
    motor1.period(0.001);   // establece el periodo del PWM, equivalente a una frecuencia de 20KHz.
    bt.baud(9600);          // velocidad de transmision del bluetooth a 9600 baudios
    int recorrido = 240;    // pulsos que queremos que recorra (modificaremos este valor hasta saber cuantos pulsos corresponden a una vuelta)
    ticker1.attach(&enviar_bt, 0.1);    // asignamos la funcion "enviar_bt" a la interrupcion del "ticker1" y le damos un intervalo de 0.1s
    
    led1 = 1;       // encendemos un led de la placa durante 1s para asegurarnos de que el programa se esta ejecutando correctamente
    wait(1);
    led1 = 0;
    
    while(pulsos<recorrido)             // gira el motor al derecho hasta que los pulsos sean los del recorrido asignado
    {
        motor1.speed(0.4);
        pulsos= encoder1.getPulses();
    }
    
    motor1.brake();         // frena el motor y enciende un led 1s para saber que hemos llegado al punto deseado
    led1 = 1;
    wait(1);
    led1 = 0;
    wait(1);
    
    while(pulsos>0)         // gira el motor al inverso hasta que los pulsos sean 0
    {
       motor1.speed(-0.4);
       pulsos= encoder1.getPulses();
    }
    
    motor1.brake();         // frena el motor y deja encendido un led para saber que hemos llegado al punto deseado
    led1 = 1;
}

void enviar_bt()            // definimos la funcion que ejecutara el ticker
{
      bt.printf("%d", pulsos);                // envia el valor de "pulsos" por bluetooth
}
