#include "mbed.h"
#include "OneButton.h"

Serial pc(SERIAL_TX, SERIAL_RX);

OneButton btn1(PC_13);

void pressed() {
    pc.printf("pressed\r\n");
}

void click() {
    pc.printf("click\r\n");
}

void double_click() {
    pc.printf("double_click\r\n");
}

void long_start() {
    pc.printf("long_start\r\n");
}

void long_hold() {
    pc.printf("long_hold\r\n");
}

void long_stop() {
    pc.printf("long_stop\r\n");
}

int main() {

    btn1.attachClick(&click);
    btn1.attachPress(&pressed);
    btn1.attachDoubleClick(&double_click);
    btn1.attachLongPressStart(&long_start);
    btn1.attachDuringLongPress(&long_hold);
    btn1.attachLongPressStop(&long_stop);

    while(1) {

        btn1.tick(); //loop
    }
}