/* Proyecto: MMA7260 Jaume */
#include "mbed.h"

BusOut mleds(LED1, LED2, LED3, LED4);
AnalogIn acelX (p20);    //Al eje X del acelerometro
AnalogIn acelY (p19);    //Al eje Y del acelerometro
AnalogIn acelZ (p18);    //Al eje Z del acelerometro
Serial pc(USBTX, USBRX); // tx, rx a 9600

int x, y, z;                        // mediciones en grados
float oneG_x, oneG_y, oneG_z;       // medidadas a operar
float zeroG_x, zeroG_y, zeroG_z;    // medidas a operar
float med_x, med_y, med_z;          // medidas adquiridas

// lee los pins analogicos 64 valores trabajando a 3.3v
void DoMeasureXYZ() {   // a 90 2,45v a 0 1,65v a -90 0,85v
    int j;
    for (j=0;j<64;j++) {
        wait_ms(1);
        med_x += acelX.read_u16();	//lecturas de 12 bits
        wait_ms(1);
        med_y += acelY.read_u16();
        wait_ms(1);
        med_z += acelZ.read_u16();
    }
    med_x = med_x/64;
    med_y = med_y/64;
    med_z = med_z/64;
}

void Read_Angles() {
    float div_x, x_rad, div_y, y_rad, div_z, z_rad ;
    DoMeasureXYZ();
    div_x = (med_x-zeroG_x) / (oneG_x-zeroG_x);    // med_G/sensibil
    x_rad = asin( div_x );                         // x angulo en radians
    x = (x_rad*180) / 3.14;                        // x angulo en grados

    div_y = (med_y-zeroG_y) / (oneG_y-zeroG_y);    // med_G/sensibil
    y_rad = asin( div_y );                         // y angulo en radians
    y = (y_rad*180) / 3.14;                        // y angulo en grados

    div_z = (med_z-zeroG_z) / (oneG_z-zeroG_z);    // med_G/sensibil
    z_rad = asin( div_z );                         // z angulo en radians
    z = (z_rad*180) / 3.14;                        // z angulo en grados
}

void calibrar() {
    printf("1.-Acelerometro posicionado paralelo al suelo \n");
    printf ("Pulsa una tecla para seguir:\n");
    while (!pc.getc());        // espera mientras no pulses una tecla
    // Medir 0g en eje X y eje Y y -1g para eje Z.
    DoMeasureXYZ();
    zeroG_x += med_x;       // 0g	165mV
    zeroG_y += med_y;       // 0g	165mV
    oneG_z  += med_z;       //-1g   85mV
    printf("2.- Acelerometro con eje X vertical flecha hacia arriba \n");
    printf ("Pulsa una tecla para seguir:\n");
    while (!pc.getc());        // espera mientras no pulses una tecla
    // para medir -1g en eje X y 0g en eje Z. El eje y es 0g ya de antes
    DoMeasureXYZ();
    oneG_x  += med_x;       // -1g
    zeroG_y += med_y;       // 0g
    zeroG_z += med_z;       // 0g
    printf ("3.- Acelerometro con eje Y vertical flecha hacia arriba \n");
    printf ("Pulsa una tecla para seguir:\n");
    while (!pc.getc());        // espera mientras no pulses una tecla
    // para medir -1G en eje Y Los otros siguen valeindo 0g
    DoMeasureXYZ();
    zeroG_x += med_x;       // 0g
    oneG_y  += med_y;       // -1g
    zeroG_z += med_z;       // 0g
    // Igualar valores medidos a 0g
    zeroG_x = zeroG_x/2;
    zeroG_y = zeroG_y/2;
    zeroG_z = zeroG_z/2;
    printf ("A  0g x %.3f y %.3f z %.3f \n",zeroG_x, zeroG_y, zeroG_z);
    printf ("A -1g x %.3f y %.3f z %.3f \n",oneG_x, oneG_y, oneG_z);
}

int main() {
    calibrar();             // Primero calibrar: Z plano X e Y flecha arriba
    while (1) {
        Read_Angles();      // Transformamos lecturas a angulos
        printf ("----------------GRADOS-------\n");
        printf ("Angulo en eje X %d \n",x);
        printf ("Angulo en eje Y %d \n",y);
        printf ("Angulo en eje Z %d \n",z);
        mleds = (x+y+z)/8;
        printf ("-------------------------------\n");
        printf ("Pulsa una tecla para seguir \n");
        while (!pc.getc());        // espera mientras no pulses una tecla
    }
}
