// SRF08 - Jaume
#include "mbed.h"
BusOut mleds(LED1, LED2, LED3, LED4);
I2C i2c(p9, p10);        // sda, scl
Serial pc(USBTX, USBRX); // tx, rx a 9600

const int addr = 0xE0; // define direccion SRF08

int main() {
    char cmd[2];             // comando
    char dat[3];             // datos a recibir
    cmd[0] = 0x02;           // puntero a reg 2
    cmd[1] = 0x8C;           // rango hasta 6m
    i2c.write(addr, cmd, 2); // escribe comandos    
    while(1) {    
        cmd[0] = 0x00;           // puntero a reg 0
        cmd[1] = 0x54;           // comando ANN cm
        i2c.write(addr, cmd, 2);
        wait(0.07);              // Espera 65ms segun data SRF08

        cmd[0] = 0x01;           // puntero a reg 1
        i2c.write(addr, cmd, 1);
        i2c.read(addr, dat, 3);  // lee 3 bytes 1 luz y 2 echo
        // imprime datos
        pc.printf("reg1  %x     reg2H %x  reg3L %x\n", dat[0], dat[1], dat[2]);
        pc.printf("---------------------------------\n");        
        pc.printf("  Luz...... = %u\n", dat[0]);
        int echo =(dat[1]<<8)+dat[2];
        pc.printf("  Distancia = %u cm.\n", echo);
        pc.printf("---------------------------------\n");
        mleds = echo/8;
        wait (1);                // espera 1000ms 
    }
}