/* Proyecto: cmps03 Jaume */

#include "mbed.h"
BusOut mleds(LED1, LED2, LED3, LED4);
I2C i2c(p9, p10);        // sda, scl
Serial pc(USBTX, USBRX); // tx, rx a 9600

const int addr = 0xC0; // define direccion CMPS03

int main() {
    char cmd[2];
    char dat[3];
    while (1) {
        cmd[0] = 0x01;                    // puntero registro 1

        i2c.write(addr, cmd, 1);
        i2c.read(addr, dat, 3);           // lee posicion 1byte y 2bytesHL
        float posicion = 360*dat[0]/255;  // posicion max 255 0 359.9
        printf("Posicion con 1 byte %.2f grados\n", posicion);
        int p = dat[0]/31;
        switch (p) {
            case 0:
                printf(" NORTE ");
                break;
            case 1:
                printf("   ESTE");
                break;
            case 2:
                printf("   ESTE");
                break;
            case 3:
                printf("  SUR  ");
                break;
            case 4:
                printf("  SUR  ");
                break;
            case 5:
                printf("OESTE  ");
                break;
            case 6:
                printf("OESTE  ");
                break;
            case 7:
                printf(" NORTE ");
        }
        mleds = dat[0]/15;
        printf (" \n");
        posicion =0.1*((dat[1]<<8)+dat[2]);    // posicion de 9 a 3599
        printf("Posicion con 2 byte %.2f grados\n", posicion);
        printf("---------------------------------------\n");
        wait(1);
    }
}
