/* Reloj en Color LCD Shield Sparkfun desde Jim Lindblom fecha: 3-2014 */
#include "mbed.h"  
#include <ColorLCDShield.h>

#define HOURS 03
#define MINUTES 00
#define SECONDS 00
#define AMPM 0  // enter 0 for AM, 1 for PM
#define CLOCK_RADIUS 50 // radio de la circunferencia de reloj
#define CLOCK_CENTER 55 // Ajusta del radio, igual es necesario reajustar
#define H_LENGTH  30    // length of hour hand
#define M_LENGTH 40     // length of minute hand
#define S_LENGTH 48     // length of second hand
#define BACKGROUND BLACK  // room for growth, adjusta color de fondo segun luz de dia
#define C_COLOR RED     // This is the color of the clock face, and digital clock
#define H_COLOR BLUE    // color de las horas
#define M_COLOR GREEN   // color de los minutos
#define S_COLOR YELLOW  // color de los segundos

LCDShield lcd;
DigitalIn buttonPin3(PTA12);
DigitalIn buttonPin4(PTA4);
DigitalIn buttonPin5(PTA5);
DigitalOut g(LED_GREEN);

Ticker reloj;
int hours, minutes, seconds, ampm;

void drawClock() {
/* drawClock() dibuja el circulo del reloj con las cifras 12,3,6 y 9 */

  lcd.setCircle(CLOCK_CENTER, 66, CLOCK_RADIUS, C_COLOR); // pinta circulo

  lcd.setStr("12", CLOCK_CENTER - CLOCK_RADIUS, 66-9, C_COLOR, BACKGROUND);
  lcd.setStr("3", CLOCK_CENTER - 9, 66 + CLOCK_RADIUS - 12, C_COLOR, BACKGROUND);
  lcd.setStr("6", CLOCK_CENTER + CLOCK_RADIUS - 18, 66-4, C_COLOR, BACKGROUND);
  lcd.setStr("9", CLOCK_CENTER - 9, 66 - CLOCK_RADIUS + 4, C_COLOR, BACKGROUND);
}

void displayAnalogTime(int h, int m, int s) {
 /* displayAnalogTime() dibuja hhmmss en su posicion correspondiente */
  double midHours;  // this will be used to slightly adjust the hour hand
  static int hx, hy, mx, my, sx, sy;
  
  /* Adjusta el tiempo para mostrar 90 grados ccw y gira en el reloj el texto */
  h -= 3;
  m -= 15;
  s -= 15;
  if (h <= 0) h += 12;
  if (m < 0)  m += 60;
  if (s < 0)  s += 60;
    
  /* Borra lineas anteriores */
  lcd.setLine(CLOCK_CENTER, 66, CLOCK_CENTER+sx, 66+sy, BACKGROUND);  // borra segundos
  lcd.setLine(CLOCK_CENTER, 66, CLOCK_CENTER+mx, 66+my, BACKGROUND);  // borra minutos
  lcd.setLine(CLOCK_CENTER, 66, CLOCK_CENTER+hx, 66+hy, BACKGROUND);  // borra horas
  
  /* Calcula y dibuja nuevas lineas */
  //s = map(s, 0, 60, 0, 360);  // ajusta de 0-60, a "360 degrees"
  s = (s-0)*(360-0)/(60-0)+360;
  sx = S_LENGTH * sin(3.14 * ((double) s)/180);  // woo trig!
  sy = S_LENGTH * cos(3.14 * ((double) s)/180);  // woo trig!
  lcd.setLine(CLOCK_CENTER, 66, CLOCK_CENTER+sx, 66+sy, S_COLOR);  // print second hand
  
  //m = map(m, 0, 60, 0, 360);  // map the 0-60, to "360 degrees"
  m = (m-0)*(360-0)/(60-0)+360;
  mx = M_LENGTH * sin(3.14 * ((double) m)/180);  // woo trig!
  my = M_LENGTH * cos(3.14 * ((double) m)/180);  // woo trig!
  lcd.setLine(CLOCK_CENTER, 66, CLOCK_CENTER+mx, 66+my, M_COLOR);  // print minute hand
  
  midHours = minutes/12;  // midHours is used to set the hours hand to middling levels between whole hours
  h *= 5;           // Get hours and midhours to the same scale
  h += midHours;    // add hours and midhours
  
  //h = map(h, 0, 60, 0, 360);  // map the 0-60, to "360 degrees"
  h = (h-0)*(360-0)/(60-0)+360;
  hx = H_LENGTH * sin(3.14 * ((double) h)/180);  // woo trig!
  hy = H_LENGTH * cos(3.14 * ((double) h)/180);  // woo trig!
  lcd.setLine(CLOCK_CENTER, 66, CLOCK_CENTER+hx, 66+hy, H_COLOR);  // print hour hand
}

void displayDigitalTime(int h, int m, int s, int ap) {
/* displayDigitalTime() muestra hh:mm:ss am/pm en parte inferior */
  char timeChar[11] = {'x','x',0x0A,'x','x',0x0A,'x','x',' ',' ',' '};
  
  /* Convierte los valores */
  timeChar[0] = h/10;
  timeChar[1] = h - (timeChar[0] * 10);
  timeChar[3] = m/10;
  timeChar[4] = m - (timeChar[3] * 10);
  timeChar[6] = s/10;
  timeChar[7] = s - (timeChar[6] * 10);
  
  /* once we have each integer separated, we need to turn them
     into displayable characters. Adding 0x30 does this (check an
     ASCII table. We set the colons to 0x0A initially, this will
     turn them into the proper 0x3A.*/
  for (int i=0; i<8; i++) timeChar[i] += 0x30;
  timeChar[8] = ' ';  // add a space between the time and AM/PM
  
  /* Add AM or PM to the end of the timeChar string */
  if (!ap) {
    timeChar[9] = 'A';
    timeChar[10] = 'M';
  }
  else {
    timeChar[9] = 'P';
    timeChar[10] = 'M';
  }
  
  /* añade espacios despues hora, otherwise it'll display unwanted characters */
  //timeChar[11] = ' ';
  //timeChar[12] = ' ';
    
  /* Print the time on the clock */
  for (int i=0; i<12; i++) {
    lcd.setChar(timeChar[i], CLOCK_CENTER + CLOCK_RADIUS + 16, 22+8*i, C_COLOR, BACKGROUND);
  }
  lcd.setStr("    ", CLOCK_CENTER + CLOCK_RADIUS + 16, 118, C_COLOR, BACKGROUND);
}

void setTime() {
  /* setTime Incrementa con S1 horas, S2 segundos y S3 para salir */ 
  /* Pone el reloj a 12 horas */
  lcd.setStr("Ajusta el reloj", 20, 1, C_COLOR, BACKGROUND);
  lcd.setStr("S1 para horas  ", 40, 1, H_COLOR, BACKGROUND);
  lcd.setStr("S2 para minutos", 60, 1, M_COLOR, BACKGROUND);
  lcd.setStr("S3 para salir  ", 80, 1, S_COLOR, BACKGROUND);
  seconds = 0;
  minutes = 0;
  hours = 12;
  ampm = 0;
  displayDigitalTime(hours, minutes, seconds, ampm);
  wait_ms(100);

  /* Mientras no pulses S3 sigues ajustando el reloj */
  while(buttonPin5) {
    /* Si pulsas S1 ajustar horas */
    if (!buttonPin3) {
      hours++;  // Increase hours by 1
      if (hours == 12) ampm ^= 1;  // Flip am/pm if it's 12 o'clock
      if (hours >= 13) hours = 1;  // Set hours to 1 if it's 13. 12-hour clock.
    }
    /* Si pulsas S2 ajustar minutos*/
    if (!buttonPin4) {
      minutes++;  // Increase minutes by 1
      if (minutes >= 60) minutes = 0;  // If minutes is 60, set it back to 0
    }
    /* and update the clock, so we can see it */ 
    displayDigitalTime(hours, minutes, seconds, ampm);
    wait_ms(100);
  }
}

void cadasegundo(){
  /* cada segundo recalcula y redibuja agujas y reloj */
  g = !g;
  if (seconds >= 60) {
    seconds = 0;  // Al llegar a 60 vuelve a 0
    minutes++;    // e incrementa los minutos
    if (minutes >= 60) {
        minutes = 0;  // Al llegar a 60 vuelve a 0
        hours++;      // e incrementa las horas
        if (hours == 12) ampm ^= 1;  // Si llega a 12 o'clock, alterna ampm
        if (hours >= 13) hours = 1;  // Si llega a 13, vuelve a 1.
    }
  }
  drawClock();
  displayAnalogTime(hours, minutes, seconds);
  displayDigitalTime(hours, minutes, seconds, ampm);
  seconds++;
}
    
int main() {
  hours = HOURS;
  minutes = MINUTES;
  seconds = SECONDS;
  ampm = AMPM;
  lcd.init(PHILLIPS);
  lcd.contrast(50);
  lcd.clear(BACKGROUND);
  setTime();
  lcd.clear(BACKGROUND);
  reloj.attach(&cadasegundo,1.0); // Cada segundo pinta y actualiza el reloj */
  
  while(1) {}
}