/* 
        CIS541: Embedded Systems for Life Critical Applications
        Project: Pacemaker modelling
*/

/* Header files */
#include "mbed.h"
#include "rtos.h"
#include "CardiacPacemaker.h"
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

/* Global variables */

// Mode-Threads pointers
Thread *threadListening;
Thread *threadLogicTiming;
Thread *threadPacing;
Thread *threadKeyboard;

Timer timerPrimary;
Timer timerSecondary;
// keypad state
// Define your own keypad values


void ThreadListeningPace(void const *args)
{
    while(1)
    {
        SenseMutex.lock();
        if(Asense==1)
        {
            ReceivedASense();
            flagA = 1;
            threadLogicTiming->signal_set(0x1);
        }
        if(Vsense==1)
        {
            ReceivedVSense();
            flagV = 1;
            threadLogicTiming->signal_set(0x1);
        }
        SenseMutex.unlock();
    }
}

void ThreadLogicTiming(void const *args)
{
    while(1)
    {
    //flagV==0 && timerPrimary.read_ms() >= LRI
    while(timerPrimary.read_ms() < PVARP)
    {
        // Post Ventricular Atrium Refractory Period
        // Ignore Asense or Vsense here
        //pc.puts("|==----(PVARP)|-----------------------------(LRI-AVI)|\n");
        //pc.puts("PVAB period\n");
        
        if(flagA == 1)
        {
            pc.puts("Early: Reject\n");
            flagA = 0;
        }
        
    }
    while(timerPrimary.read_ms() >= PVARP && timerPrimary.read_ms() < (LRI-AVI))
    {
        // Normal Asense period
        //pc.puts("|======(PVARP)|=====----------(tAs+AVI)|----(LRI-AVI)|\n");
        //pc.puts("Normal Asense period\n");
        if(flagA == 1)
        {
            // Acknowledge reception of Asense
            pc.puts("Normal:Asense\n");
            SendAPace();
            flag1 = 1;
            flagA = 0;
            //pc.puts("|======(PVARP)|=====(As)=-------(tAs+AVI)|----(LRI-AVI)\n");
            break;   
        }
    }
    if(timerPrimary.read_ms() > (LRI-AVI) )
    {
        // Asense period exhausted pacemaker needs to Apace the heart
        if(flag1==0)
        {
            SendAPace(); //Forced Atrium Pulse reffering to the below if loop
        }
        else
        {
            flag1 = 0;
        }
        if(flagA == 1)
        {
            pc.puts("Late: Rejected\n");
            flagA = 0;  //just to cleanup for next cycle
        }
        //pc.puts("|======(PVARP)|================================(Ap)(LRI-AVI)|\n");
        // look for Vsense
        while(timerPrimary.read_ms() < (LRI-AVI)+PVAB)
        {
            // This is Post Atrium Ventricular Blanking period
            // No Vsense should be here
            // Ignore any V here
        }
        while(timerPrimary.read_ms() >= (LRI-AVI)+PVAB && timerPrimary.read_ms() < (LRI-AVI)+VSP)
        {
            // This is Ventricular _______ period
            // Vsense here would be prematuare and needs to be sent at the end of the period as mature
            // Receive and matuare any V here
            if(flagV == 1)
            {
                pc.puts("Unmatured:Converted into matuared\n");
                //ReceivedVSense(); //pre-mature
                while(timerPrimary.read_ms() < (LRI-AVI)+VSP); //maturing it
                flagV = 0;
                SendVPace();    //matuared
                //LEDTest = 0;
                //pc.puts("|======(PVARP)|================================(Ap)(LRI-AVI)|===(Vsp)===(Vpm)(tVSP)\n");
            }
        }
        while(timerPrimary.read_ms() >= (LRI-AVI)+VSP && timerPrimary.read_ms() < LRI)
        {
            // This is normal period for Vsense 
            // Vsense here would be matuare 
            if(flagV == 1)
            {
                pc.puts("Matuared:\n");
                ReceivedVSense(); //mature
                SendVPace();
                flagV = 0;
                flag2=1;
                //pc.puts("|======(PVARP)|================================(Ap)(LRI-AVI)|============(Vsm)(tVSP)\n");
                break;
            }
        }
        if(timerPrimary.read_ms() > LRI)
        {
            // Waiting time for Vsense exhausted
            // Pacemaker needs to generate Vpace now
            // send Vpace and reset timers
            if(flag2==0)
            {
                SendVPace(); //Forced ventricle Pulse reffering to the below if loop
            }
            else
            {
                flag2 = 0;
            }
            //pc.puts("|======(PVARP)|================================(Ap)(LRI-AVI)|=======================(Vp)(LRI)\n");
            timerPrimary.reset();   // reset for next beat interval
            
        }
        else if(timerPrimary.read_ms() >= (LRI-AVI)+VSP && timerPrimary.read_ms() < LRI)
        {
            // matuare Vsense was received
            // inhibit sending any Vpace
            // Reset timers
            
            timerPrimary.reset();   // reset for next beat interval
        }
        
    }
    else if(timerPrimary.read_ms() < (LRI-AVI) )
    {
        // Asense observed within the normal period pacemaker does nothing 
        
        // now look for VSense witin next AVI
        timerSecondary.start();
        while(timerSecondary.read_ms() < AVI)
        {
            if(flagV == 1)
            {
                pc.puts("Natural Asense, Natural Vsense:\n");
                ReceivedVSense();
                SendVPace();
                flag2=1;
                flagV = 0;
                //pc.puts("|======(PVARP)|=====(As)==(Vs)|---(tAs+AVI)|----(LRI-AVI)\n");
                break;
            }
        }
        if(timerSecondary.read_ms() >= AVI)
        {
            while(timerPrimary.read_ms() < URI);    // wait till URI to send Vpace
            if(flag2==0)
            {
                SendVPace(); //Forced Atrium Pulse reffering to the below if loop
            }
            else
            {
                flag2 = 0;
            }
            //pc.puts("|======(PVARP)|=====(As)==================(Vp)(URI)|----(LRI-AVI)\n");
        }
        else if(timerSecondary.read_ms() < AVI) //still less than AVI
        {
            // This means Vsense is already observed
            // both A and V have been managed successfully
            // Reset timers before reinitiating the process
            timerPrimary.reset();
            timerSecondary.stop();
            timerSecondary.reset();
        }
        
    }
    
    }//while(1) ends here
}



void SetSleepMode()
{
    VRP = 200;
    AVI = 200;
    PVARP = 500;
    VSP = 100;
    PVAB = 100;
    LRI = 2000;
    URI = 1000;
    pc.puts("\nSleep Mode.");
}

void SetExerciseMode()
{
    VRP = 200;
    AVI = 200;
    PVARP = 500;
    VSP = 100;
    PVAB = 100;
    LRI = 600;
    URI = 343;
    pc.puts("\nExercise Mode.");
}

void SetNormalMode()
{
    VRP = 200;
    AVI = 200;
    PVARP = 500;
    VSP = 100;
    PVAB = 100;
    LRI = 1500;
    URI = 600;
    pc.puts("\nNormal Mode.");
}

void SetObservationMode()
{
    pc.puts("\nEnter new observation Time (in sec): ");
    pc.puts("\nPress 1 for 10 sec ");
    pc.puts("\nPress 2 for 20 sec ");
    pc.puts("\nPress 3 for 30 sec ");

}

void ThreadKeyboard(void const *args)
{
    char key;
    while(1)
    {
        if(pc.readable())
        {
            key = pc.getc();
            pc.putc(key);
            
            switch(key){
                case 's': SetSleepMode(); break;
                case 'x': SetExerciseMode(); break;
                case 'n': SetNormalMode(); break;
                case 'o': SetObservationMode(); break;
                case '1': obsPeriod=10000; pc.puts("\nObsPeriod set to 10sec"); break;
                case '2': obsPeriod=20000; pc.puts("\nObsPeriod set to 20sec"); break;
                case '3': obsPeriod=30000; pc.puts("\nObsPeriod set to 30sec"); break;
                
            }
        }
    }
}
        

int main(void)
{  
    setbuf(stdout,NULL);
    threadListening = new Thread(ThreadListeningPace);
    threadLogicTiming = new Thread(ThreadLogicTiming);
    threadKeyboard = new Thread(ThreadKeyboard);
    
    timerPrimary.start();
}
    