#include "mbed.h"
#include "MPU6050.h"
#include "ADXL345_I2C.h"
 
//DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
MPU6050 mpu;
ADXL345_I2C accelerometer(I2C_SDA, I2C_SCL);

int16_t MPU_ax, MPU_ay, MPU_az;
int16_t MPU_gx, MPU_gy, MPU_gz;

int main()
{
    pc.baud(115200);
    
    
    pc.printf("MPU6050 test\n\n");
    pc.printf("MPU6050 initialize \n");
 
    mpu.initialize();
    pc.printf("MPU6050 testConnection \n");

    bool mpu6050TestResult = mpu.testConnection();
    if(mpu6050TestResult) {
        pc.printf("MPU6050 test passed \n");
    } else {
        pc.printf("MPU6050 test failed \n");
    }
    
    int ADXL_readings[3] = {0, 0, 0};
    
    // These are here to test whether any of the initialization fails. It will print the failure
    if (accelerometer.setPowerControl(0x00))
    {
         pc.printf("Couldn't intitialize power control\n");  
    }
     //Full resolution, +/-16g, 4mg/LSB.
     wait(.001);
     
     if(accelerometer.setDataFormatControl(0x0B))
     {
        pc.printf("Couldn't set data format\n");        
     }
     wait(.001);
     
     //3.2kHz data rate.
     if(accelerometer.setDataRate(ADXL345_3200HZ))
     {
        pc.printf("didn't set data rate\n");        
     }
     wait(.001);
     
     //Measurement mode.
     
     if(accelerometer.setPowerControl(MeasurementMode)) 
     {
        pc.printf("Couldn't set the power control to measurement\n");         
     } 

    while(1) {        
        mpu.getMotion6(&MPU_ax, &MPU_ay, &MPU_az, &MPU_gx, &MPU_gy, &MPU_gz);
        accelerometer.getOutput(ADXL_readings);
        
        //writing current accelerometer and gyro position 
        pc.printf("MPU: %d;%d;%d;%d;%d;%d\r\n",MPU_ax,MPU_ay,MPU_az,MPU_gx,MPU_gy,MPU_gz);                         
        pc.printf("ADXL: %i, %i, %i\r\n\n", (int16_t)ADXL_readings[0], (int16_t)ADXL_readings[1], (int16_t)ADXL_readings[2]);
        
        wait(0.01);
    }
}