/*
Designed to work from year 2015 to 2020
*/

#include "mbed.h"
#include "arm_math.h"
#include "SDFileSystem.h"
#include "arm_common_tables.h"
#define freq 1
#define fft_points 16384
#define dur_sec 16.384
#define module_name "NTF10"

Serial pc(USBTX, USBRX);
Serial gsm(D1, D0);
AnalogIn AC_input(A0);
AnalogIn AC2_input(A1);
AnalogIn DC_input(A2);
AnalogIn DC_Detect(A3);
AnalogIn TC1(A4);
AnalogIn TC2(A5);
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");
DigitalOut gsm_rst(D7);

char sitename[100] = module_name;
char filename[100] = "";
char filepath[100] = "";
char timestamp[100]="";
char time_stamp[20]="";
char timestampold[100]="";
char main_dir[100] ="";
char hour_dir[100] ="";
char pathAC[100]   ="";
char pathDC[100]   ="";
char pathDCdetect[100]   ="";
char pathfft[100]="";
//char putpathname[100]="";
char filenameAC[100]   ="";
char filenameDC[100]   ="";
char filenamefft[100]   ="";
char clk_response[100] ="";
int m=0,mfinal;
int date, month, year, hour, minute, second,minuteold, secondold, temp = 0;
unsigned long var = 0;
unsigned long currentMillis = 0;
uint8_t x=0,z=0,answer=0;
int gsmerr=0;
char pswd[100]= "*PSNWID:";

time_t previous;


int fft_array[32768];//={37767, 34339, 31062, 28224, 26011, 24245, 22588, 21757, 22460, 24288, 27136, 30535, 33829, 36639, 38848, 40598, 42239, 43047, 42302, 40468, 37592, 34182, 30924, 28082, 25922, 24153, 22509, 21739, 22534, 24403, 27302, 30689, 33965, 36774, 38946, 40688, 42324, 43064, 42222, 40351, 37424, 34013, 30787, 27940, 25834, 24067, 22432, 21742, 22605, 24522, 27466, 30863, 34102, 36908, 39018, 40773, 42396, 43057, 42166, 40210, 37256, 33851, 30656, 27800, 25746, 23996, 22353, 21752, 22675, 24648, 27636, 31024, 34230, 37052, 39113, 40859, 42468, 43052, 42090, 40095, 37085, 33682, 30524, 27675, 25656, 23904, 22285, 21744, 22739, 24772, 27811, 31199, 34377, 37176, 39206, 40933, 42546, 43037, 42017, 39960, 36916, 33518, 30383, 27553, 25570, 23822, 22218, 21765, 22825, 24910, 27970, 31355, 34516, 37293, 39292, 41021, 42615, 43033, 41936, 39822, 36733, 33359, 30240, 27444, 25487, 23731, 22146, 21769, 22897, 25052, 28145, 31520, 34655, 37403, 39378, 41105, 42682, 43039, 41858, 39687, 36566, 33192, 30094, 27327, 25399, 23655, 22073, 21777, 22989, 25194, 28323, 31692, 34805, 37512, 39456, 41191, 42744, 43019, 41768, 39560, 36389, 33026, 29941, 27223, 25317, 23580, 22016, 21803, 23077, 25320, 28498, 31841, 34950, 37621, 39537, 41268, 42797, 42995, 41686, 39427, 36223, 32858, 29798, 27112, 25246, 23496, 21971, 21828, 23160, 25454, 28663, 32023, 35091, 37721, 39618, 41345, 42840, 42979, 41595, 39295, 36042, 32717, 29648, 27010, 25158, 23417, 21929, 21846, 23241, 25591, 28832, 32141, 35248, 37826, 39716, 41415, 42890, 42949, 41508, 39157, 35874, 32582, 29495, 26901, 25076, 23346, 21884, 21888, 23343, 25723, 28993, 32307, 35390, 37934, 39790, 41488, 42925, 42903, 41406, 39030, 35723, 32404, 29355, 26803, 24986, 23272, 21852, 21935, 23436, 25863, 29158, 32473, 35530, 38037, 39868, 41566, 42958, 42852, 41319, 38884, 35553, 32248, 29201, 26701, 24900, 23188, 21834, 21983, 23515, 26001, 29320, 32636, 35672, 38141, 39962, 41655, 42972, 42810, 41229, 38759, 35378, 32087, 29059, 26601, 24811, 23105, 21809, 22027, 23618, 26136, 29491, 32806, 35820, 38239, 40047, 41727, 42999, 42757, 41130, 38608, 35221, 31912, 28911, 26501, 24729, 23032, 21794, 22089, 23713, 26298, 29641, 32995, 35956, 38344, 40128, 41805, 43016, 42688, 41028, 38463, 35065, 31730, 28779, 26413, 24643, 22931, 21778, 22154, 23809, 26440, 29802, 33164, 36082, 38442, 40227, 41899, 43025, 42627, 40930, 38304, 34903, 31562, 28651, 26320, 24546, 22839, 21770, 22224, 23914, 26596, 29971, 33327, 36205, 38539, 40315, 41985, 43031, 42559, 40833, 38153, 34719, 31410, 28515, 26226, 24450, 22763, 21755, 22291, 24021, 26764, 30153, 33492, 36334, 38624, 40409, 42068, 43033, 42473, 40722, 37981, 34554, 31252, 28403, 26130, 24361, 22680, 21756, 22360, 24149, 26928, 30318, 33645, 36465, 38732, 40493, 42148, 43048, 42416, 40609, 37804, 34390, 31095, 28260, 26034, 24272, 22605, 21748, 22438, 24252, 27087, 30487, 33780, 36596, 38826, 40578, 42212, 43049, 42342, 40491, 37644, 34223, 30958, 28119, 25949, 24193, 22538, 21743, 22516, 24371, 27257, 30645, 33927, 36742, 38915, 40661, 42298, 43058, 42254, 40377, 37472, 34056, 30822, 27973, 25853, 24095, 22461, 21736, 22578, 24485, 27427, 30817, 34064, 36885, 39007, 40754, 42379, 43062, 42186, 40250, 37306, 33892, 30686, 27834, 25766, 24012, 22381, 21740, 22661, 24613, 27601, 30971, 34198, 37003, 39098, 40823, 42451, 43054, 42107, 40122, 37132, 33733, 30548, 27703, 25675, 23923, 22298, 21749, 22723, 24738, 27767, 31154, 34344, 37149, 39177, 40920, 42527, 43053, 42035, 39999, 36967, 33570, 30405, 27579, 25589, 23843, 22226, 21750, 22802, 24872, 27942, 31312, 34487, 37275, 39276, 41002, 42602, 43044, 41964, 39853, 36775, 33388, 30267, 27468, 25508, 23758, 22161, 21760, 22876, 25017, 28132, 31492, 34625, 37377, 39353, 41087, 42673, 43035, 41879, 39724, 36611, 33232, 30123, 27356, 25420, 23671, 22082, 21769, 22960, 25153, 28291, 31655, 34762, 37497, 39436, 41171, 42730, 43030, 41794, 39586, 36427, 33073, 29978, 27247, 25331, 23593, 22025, 21781, 23052, 25286, 28463, 31814, 34918, 37592, 39524, 41247, 42785, 43012, 41708, 39453, 36258, 32912, 29822, 27138, 25249, 23517, 21973, 21799, 23135, 25424, 28629, 31970, 35073, 37709, 39615, 41330, 42836, 42995, 41620, 39315, 36077, 32745, 29669, 27034, 25191, 23437, 21925, 21830, 23222, 25563, 28797, 32137, 35208, 37821, 39688, 41407, 42877, 42958, 41574, 39183, 35908, 32593, 29529, 26921, 25084, 23355, 21888, 21872, 23324, 25701, 28966, 32285, 35359, 37917, 39785, 41486, 42912, 42925, 41440, 39041, 35744, 32444, 29380, 26820, 24997, 23274, 21860, 21910, 23410, 25839, 29133, 32438, 35505, 38025, 39853, 41550, 42945, 42870, 41341, 38904, 35579, 32292, 29225, 26720, 24921, 23208, 21831, 21969, 23510, 25982, 29290, 32604, 35645, 38122, 39944, 41627, 42969, 42826, 41248, 38768, 35416, 32127, 29075, 26612, 24827, 23121, 21808, 22020, 23602, 26115, 29461, 32775, 35796, 38225, 40030, 41719, 42997, 42763, 41142, 38629, 35248, 31935, 28938, 26524, 24743, 23039, 21794, 22084, 23698, 26271, 29616, 32967, 35921, 38322, 40109, 41798, 43001, 42705, 41053, 38484, 35095, 31768, 28794, 26428, 24644, 22954, 21781, 22136, 23800, 26431, 29785, 33142, 36060, 38435, 40209, 41877, 43022, 42645, 40950, 38308, 34923, 31600, 28677, 26330, 24564, 22862, 21770, 22201, 23898, 26577, 29947, 33302, 36191, 38527, 40297, 41974, 43032, 42572, 40839, 38160, 34763, 31432, 28541, 26241, 24472, 22770, 21758, 22280, 24004, 26741, 30117, 33465, 36324, 38619, 40393, 42062, 43043, 42494, 40738, 37996, 34606, 31268, 28406, 26148, 24377, 22685, 21747, 22359, 24116, 26903, 30292, 33626, 36453, 38702, 40486, 42145, 43042, 42427, 40636, 37828, 34424, 31128, 28272, 26056, 24292, 22617, 21749, 22425, 24226, 27060, 30455, 33772, 36579, 38811, 40569, 42216, 43047, 42343, 40526, 37652, 34251, 30980, 28134, 25962, 24203, 22538, 21748, 22497, 24334, 27233, 30636, 33906, 36731, 38904, 40654, 42294, 43050, 42264, 40407, 37493, 34083, 30850, 27979, 25871, 24104, 22462, 21741, 22562, 24463, 27400, 30800, 34050, 36873, 38991, 40745, 42376, 43057, 42203, 40274, 37323, 33913, 30717, 27836, 25778, 24018, 22392, 21740, 22638, 24593, 27572, 30958, 34182, 36999, 39082, 40827, 42444, 43052, 42130, 40147, 37185, 33751, 30579, 27712, 25689, 23936, 22315, 21733, 22711, 24726, 27744, 31128, 34319, 37133, 39174, 40909, 42518, 43057, 42048, 40013, 36980, 33586, 30433, 27596, 25607, 23852, 22242, 21745, 22786, 24858, 27913, 31304, 34444, 37266, 39251, 40995, 42605, 43048, 41967, 39876, 36817, 33397, 30313, 27467, 25520, 23781, 22152, 21755, 22872, 24990, 28082, 31479, 34590, 37369, 39344, 41070, 42676, 43042, 41893, 39750, 36644, 33236, 30159, 27364, 25434, 23698, 22082, 21773, 22947, 25129, 28256, 31645, 34733, 37483, 39438, 41138, 42741, 43021, 41815, 39606, 36470, 33074, 30011, 27247, 25338, 23619, 22018, 21788, 23038, 25281, 28427, 31804, 34883, 37589, 39528, 41222, 42799, 42991, 41711, 39466, 36293, 32914, 29851, 27159, 25256, 23543, 21963, 21813, 23117, 25421, 28599, 31966, 35030, 37699, 39604, 41310, 42845, 42987, 41633, 39326, 36117, 32761, 29696, 27048, 25178, 23459, 21913, 21853, 23210, 25559, 28764, 32121, 35190, 37790, 39668, 41375, 42891, 42946, 41534, 39196, 35949, 32611, 29544, 26944, 25086, 23384, 21880, 21891, 23304, 25696, 28940, 32274, 35340, 37896, 39778, 41450, 42930, 42891, 41455, 39054, 35780, 32455, 29402, 26845, 25003, 23305, 21850, 21941, 23385, 25829, 29108, 32414, 35493, 37998, 39867, 41538, 42960, 42853, 41372, 38918, 35598, 32301, 29237, 26740, 24905, 23236, 21825, 21996, 23478, 25973, 29276, 32578, 35636, 38101, 39955, 41603, 42981, 42798, 41270, 38769, 35438, 32147, 29090, 26644, 24818, 23154, 21803, 22046, 23577, 26105, 29437, 32753, 35780, 38195, 40046, 41686, 43002, 42748, 41181, 38637, 35270, 31972, 28946, 26540, 24729, 23070, 21784, 22090, 23672, 26263, 29600, 32928, 35923, 38303, 40124, 41763, 43022, 42692, 41074, 38488, 35109, 31792, 28800, 26454, 24644, 22979, 21767, 22160, 23766, 26411, 29762, 33111, 36054, 38392, 40214, 41858, 43034, 42628, 40970, 38337, 34937, 31640, 28662, 26374, 24554, 22888, 21760, 22224, 23871, 26565, 29936, 33262, 36188, 38484, 40306, 41949, 43044, 42549, 40874, 38187, 34765, 31476, 28537, 26273, 24458, 22797, 21755, 22293, 23971, 26718, 30114, 33422, 36324, 38589, 40397, 42037, 43050, 42478, 40765, 38012, 34592, 31319, 28415, 26174, 24365, 22716, 21745, 22364, 24083, 26880, 30288, 33579, 36444, 38683, 40478, 42111, 43051, 42411, 40659, 37853, 34422, 31166, 28287, 26072, 24290, 22645, 21746, 22435, 24200, 27051, 30456, 33727, 36587, 38777, 40564, 42188, 43061, 42332, 40544, 37684, 34241, 31023, 28138, 25979, 24202, 22562, 21736, 22510, 24316, 27218, 30627, 33874, 36717, 38881, 40650, 42271, 43065, 42262, 40418, 37516, 34082, 30883, 27986, 25891, 24115, 22486, 21733, 22586, 24440, 27373, 30778, 34011, 36848, 38970, 40727, 42351, 43061, 42184, 40293, 37352, 33921, 30749, 27849, 25801, 24030, 22397, 21741, 22656, 24573, 27550, 30960, 34144, 36988, 39050, 40808, 42427, 43053, 42104, 40173, 37190, 33759, 30618, 27727, 25713, 23956, 22321, 21745, 22723, 24686, 27700, 31121, 34273, 37127, 39155, 40906, 42515, 43054, 42049, 40037, 37003, 33582, 30481, 27603, 25618, 23870, 22244, 21752, 22795, 24834, 27881, 31283, 34419, 37241, 39239, 40965, 42587, 43046, 41970, 39910, 36842, 33427, 30336, 27486, 25523, 23788, 22167, 21763, 22859, 24982, 28056, 31458, 34565, 37359, 39331, 41051, 42660, 43038, 41897, 39754, 36671, 33251, 30189, 27381, 25450, 23713, 22092, 21772, 22943, 25119, 28232, 31625, 34711, 37462, 39413, 41133, 42725, 43020, 41806, 39631, 36497, 33078, 30038, 27270, 25363, 23622, 22030, 21793, 23027, 25251, 28398, 31795, 34858, 37568, 39494, 41218, 42791, 43005, 41728, 39486, 36319, 32923, 29880, 27167, 25279, 23547, 21975, 21823, 23112, 25387, 28584, 31967, 35015, 37671, 39590, 41304, 42840, 42977, 41646, 39350, 36129, 32761, 29723, 27061, 25181, 23463, 21923, 21847, 23198, 25542, 28753, 32110, 35175, 37780, 39687, 41367, 42888, 42965, 41554, 39192, 35956, 32615, 29574, 26952, 25099, 23395, 21886, 21885, 23295, 25686, 28923, 32259, 35320, 37886, 39766, 41449, 42924, 42905, 41452, 39062, 35787, 32454, 29411, 26846, 25005, 23314, 21849, 21935, 23394, 25824, 29094, 32420, 35480, 37982, 39864, 41529, 42962, 42850, 41378, 38922, 35613, 32315, 29255, 26748, 24908, 23231, 21817, 21979, 23463, 25980, 29265, 32573, 35635, 38092, 39954, 41609, 42983, 42806, 41284, 38788, 35444, 32154, 29102, 26647, 24831, 23158, 21803, 22038, 23562, 26104, 29426, 32740, 35778, 38189, 40035, 41672, 43003, 42758, 41188, 38646, 35286, 31986, 28959, 26548, 24738, 23078, 21785, 22092, 23659, 26251, 29596, 32920, 35918, 38289, 40114, 41760, 43019, 42695, 41085, 38501, 35119, 31809, 28814, 26461, 24658, 22986, 21771, 22143, 23759, 26388, 29759, 33093, 36053, 38386, 40210, 41850, 43032, 42629, 40981, 38356, 34947, 31639, 28684, 26371, 24555, 22896, 21758, 22219, 23855, 26546, 29922, 33252, 36181, 38485, 40299, 41940, 43041, 42539, 40899, 38186, 34776, 31492, 28569, 26280, 24470, 22814, 21750, 22279, 23963, 26709, 30091, 33420, 36319, 38589, 40392, 42029, 43051, 42496, 40762, 38023, 34613, 31330, 28419, 26178, 24374, 22723, 21744, 22345, 24068, 26866, 30262, 33563, 36441, 38680, 40488, 42113, 43056, 42422, 40670, 37860, 34441, 31170, 28291, 26083, 24288, 22650, 21739, 22429, 24180, 27038, 30440, 33720, 36585, 38781, 40566, 42190, 43051, 42349, 4055};
unsigned short ACdata[fft_points];
unsigned short DCdata[fft_points];
unsigned short DC_Detect_data[10];

uint32_t dataLength = dur_sec*freq*1000;

//--------------------------------------------------------------------------------------------------//
//                  Module reset                                                                    //
//--------------------------------------------------------------------------------------------------//
void reset_mod()
{
    NVIC_SystemReset();
}

//--------------------------------------------------------------------------------------------------//
//                  Send AT Command (1 response with clk variable)                                                    //
//--------------------------------------------------------------------------------------------------//
bool sendATcommand(char* ATcommand, char* expected_answer, unsigned int timeout, bool clk_flag)
{
    int x=0;
    bool answer=0;                                                                           //x=0 and answer=0, if not put, AT+CCLK?\r is not executed
    char response[100];
    memset(response, '\0', 100);                                                                    // Initialize the string
    wait_ms(100);
    previous = time(NULL);
    char dummy;
    do{
        if(gsm.readable()!=0){ 
            dummy=gsm.getc();
            pc.putc(dummy);
            } 
        }
    while((time(NULL) - previous) < 1);                                                          // Clean the input buffer
    gsm.printf("%s \r", ATcommand);                                                                 // Send the AT command
    x = 0;
    previous = time(NULL);
    do {                                                                                            // this loop waits for the answer
        if(gsm.readable() != 0) {
            response[x] = gsm.getc();                                                               // if there are data in the UART input buffer, reads it and checks for the asnwer
            pc.putc(response[x]);
            x++;
            if (strstr(response, expected_answer) != NULL) {                                        // check if the desired answer  is in the response of the module
                answer = 1;
                }
            }
        } while((answer == 0) && ((time(NULL) - previous) < timeout));                                  // Waits for the asnwer with time out
    if(clk_flag == 1) {
        sprintf(timestamp,response);                                                                //copies response to timestamp for further processing    }
    }
    return answer;
    
    
}

//--------------------------------------------------------------------------------------------------//
//                  Getting File Directories and names                                              //
//--------------------------------------------------------------------------------------------------//
void GetFileDir()
{
    int attempt_cnt=0;
    char month_dir[100]="";
    char date_dir[100] ="";
    sendATcommand("AT+CCLK?\r", "OK", 5,1);
    //sprintf(response,timestamp);
    x=20;
    year = 10*(timestamp[x+1]-48) + (timestamp[x+2]-48);
    month = (timestamp[x+4]-48)*10+(timestamp[x+5]-48);
    date = (timestamp[x+7]-48)*10+(timestamp[x+8]-48);
    hour = (timestamp[x+10]-48)*10+(timestamp[x+11]-48);
    minute = (timestamp[x+13]-48)*10+(timestamp[x+14]-48);
    second = (timestamp[x+16]-48)*10+(timestamp[x+17]-48);

    sprintf(time_stamp,"%02d%02d%02d%02d%02d%02d",year,month,date,hour,minute,second);
    while(year<15||year>20) {
        sendATcommand("AT+CCLK?\r", "OK", 5,0);
        year = 10*(timestamp[x+1]-48) + (timestamp[x+2]-48);
        attempt_cnt++;
        if(attempt_cnt>4) break;
    }
    if(year>14&&year<21) {
        if((minute!=minuteold)||(second!=secondold)) {
            sprintf(timestampold,timestamp);
            //pc.printf("\r\nold time stamp is%s\r\n",timestampold);
            minuteold=minute;
            secondold=second;        
            sprintf(main_dir,"/sd/%s",sitename);
            sprintf(month_dir,"%s/%s%02d%02d",main_dir,sitename,year,month);
            sprintf(date_dir,"%s/%s%02d%02d%02d",month_dir,sitename,year,month,date);
            sprintf(hour_dir,"%s/%s%02d%02d%02d%02d",date_dir,sitename,year,month,date,hour);
            sprintf(filepath,"%s/%s%02d%02d%02d%02d%02d%02d",hour_dir,sitename,year,month,date,hour,minute,second);
            sprintf(filename,"%s%02d%02d%02d%02d%02d%02d",sitename,year,month,date,hour,minute,second);
            //sprintf(putpathname,
            gsmerr=0;
            mkdir(main_dir,0777);
            mkdir(month_dir,0777);
            mkdir(date_dir,0777);
            mkdir(hour_dir,0777);
        } else {
            sprintf(filepath,"%s/%s%02d%02d%02d%02d%02d%02dErr%03d",hour_dir,sitename,year,month,date,hour,minute,second,gsmerr);
            sprintf(filename,"%s%02d%02d%02d%02d%02d%02dErr%03d",sitename,year,month,date,hour,minute,second,gsmerr);
            gsmerr++;
        }
    } else {
        sprintf(timestamp,timestampold);
        sprintf(filepath,"%s/%s%02d%02d%02d%02d%02d%02dErr%03d",hour_dir,sitename,year,month,date,hour,minute,second,gsmerr);
        sprintf(filename,"%s%02d%02d%02d%02d%02d%02dErr%03d",sitename,year,month,date,hour,minute,second,gsmerr);
        gsmerr++;
    }
}

//--------------------------------------------------------------------------------------------------//
//                  DC Detect                                                                       //
//--------------------------------------------------------------------------------------------------//
void DC_Detection()
{
    Timer t;
    int j=0;
    t.start();
    while(j<10) {
        if((int)(t.read()*50*freq*1000)%100 == 0) {
            DC_Detect_data[j] = DC_Detect.read_u16();
            ++j;
        }
    }
    t.stop();
    // pc.printf("\r\nTemp Time Taken %f \n\r", t.read());
    t.reset();
    // pc.printf("Total Samples %d\r\n",j);
    //osSignalSet(tid3, 0x1);
}

//--------------------------------------------------------------------------------------------------//
//                  AC-DC Sampling                                                                  //
//--------------------------------------------------------------------------------------------------//
void calculate_ADC()
{
    Timer t;
    int j=0;
    //pc.printf("\n\rStarting Reading \n\r");
    t.start();
    while(j<dataLength) {
        if((int)(t.read()*100*freq*1000)%100 == 0) {
            ACdata[j] = AC_input.read_u16();
            DCdata[j] = DC_input.read_u16();
            ++j;
        }
    }
    t.stop();
    //pc.printf("Time Taken %f \n\r", t.read());
    t.reset();
    //pc.printf("Total Samples %d\r\n",j);
}

//--------------------------------------------------------------------------------------------------//
//                 Sampling Function                                                                //
//--------------------------------------------------------------------------------------------------//

void sampling()
{
    //int smplngcnt=0;
    //tid1 = osThreadGetId();
    //while(true)
    //{
    pc.printf("\r\nSampling attempt");
    calculate_ADC();
    DC_Detection();
    /*for(int i=0;i<30; i++)
     {
       Thread::wait(60000);
     }
    }*/
}

void fft(short N, short start_index, short step, int loop)
{
    if(N==2048) {
        float input_2048[2048];
        for (short i=0; i<2048; i++) {
            input_2048[i]=float(fft_array[(start_index+i*step)]);
        }
        float output_4096[4096];
        arm_rfft_instance_f32 SR;
        arm_cfft_radix4_instance_f32 SR_CFFT;
        arm_status status=arm_rfft_init_f32(&SR, &SR_CFFT, 2048, 0, 1);
        arm_rfft_f32(&SR, input_2048, output_4096);
        for (short i=0; i<4096; i++) {
            fft_array[start_index+i*step]=int(output_4096[i]);
        }
        return;
    } else {
        fft(N/2, start_index, step*2,0);
        fft(N/2, start_index+step, step*2,0);
        float output_data1[2];
        float output_data2[2];
        float output_data3[2];
        float output_data4[2];
        output_data3[0]=fft_array[start_index];
        output_data3[1]=fft_array[start_index+2*step];
        output_data4[0]=fft_array[start_index+step];
        output_data4[1]=fft_array[start_index+3*step];
        fft_array[start_index]=output_data3[0]+output_data4[0];
        fft_array[start_index+step]=output_data3[1]+output_data4[1];
        for(int i=1; i<N/2; i++) {
            output_data1[0]=float(fft_array[start_index+4*(i)*step]);
            output_data1[1]=float(fft_array[start_index+(4*(i)+2)*step]);
            output_data2[0]=float(fft_array[start_index+(4*(i)+1)*step]);
            output_data2[1]=float(fft_array[start_index+(4*(i)+3)*step]);
            fft_array[start_index+2*i*step]=int(output_data1[0]+(output_data2[0]*cos(2*i*3.142/N))-(output_data2[1]*sin(-2*i*3.142/N)));
            fft_array[start_index+(2*i+1)*step]=int(output_data1[1]+(output_data2[0]*sin(-2*i*3.142/N))+(output_data2[1]*cos(2*i*3.142/N)));
        }
        fft_array[start_index+N*step]=output_data3[0]-output_data4[0];
        fft_array[start_index+(N+1)*step]=output_data3[1]-output_data4[1];
        if(loop==0) {
            for(int i=N/2+1; i<N; i++) {
                fft_array[start_index+2*i*step]=fft_array[start_index+2*(N-i)*step];
                fft_array[start_index+(2*i+1)*step]=-1*fft_array[start_index+(2*(N-i)+1)*step];
            }
        }
        if(loop==1) {
            for(short i=0; i<8193; i++) {
                fft_array[i]=int(sqrt((double(fft_array[2*i])*double(fft_array[2*i]))+(double(fft_array[2*i+1])*double(fft_array[2*i+1]))));
            }
        }
        return;
    }
}
void fft_max(int start_index, int number_count, int maximal_count, uint32_t* maximum_index, float* maximum_value)
{
    float maximal_array[number_count];
    for (int i=0; i<number_count; i++) {
        maximal_array[i]=float(fft_array[start_index+i]);
    }
    for(int i=0; i<maximal_count; i++) {
        arm_max_f32(maximal_array,number_count,&maximum_value[i],&maximum_index[i]);
        maximal_array[maximum_index[i]]=0;
        maximum_index[i]=start_index+maximum_index[i];
    }
}

void prepare_fft_array(int* start_index, int* points_count, int* maximas_required, int segments, int fft_type)
{
    int max_points_count=0;
    for (int i=0; i<segments; i++) {
        max_points_count=max_points_count+maximas_required[i];
    }
    uint32_t index[max_points_count];
    float maxima[max_points_count];
    int j=0;
    for (int i=0; i<segments; i++) {
        fft_max(start_index[i],points_count[i],maximas_required[i],&index[j],&maxima[j]);
        j=j+maximas_required[i];
    }
    FILE *fp = fopen(pathfft, "a");
    if(fp == NULL) {
        pc.printf("Could not open file for write\n\r");
        //reset_mod();
    } else {
        //fprintf(fp, "\r\n%s",timestamp);
        for(int i=0; i<max_points_count; i++) {
            fprintf(fp,"\r\n %d %d",index[i], int(maxima[i]));
        }
        if(fft_type==0) fprintf(fp,"\r\n\r\n");
        else fprintf(fp,"\r\nEOF");
        fclose(fp);
    }
}

//--------------------------------------------------------------------------------------------------//
//                  Storage                                                                         //
//--------------------------------------------------------------------------------------------------//
void store()
{
    /*tid3 = osThreadGetId();
    while(true)
    {
        osSignalWait(0x1, osWaitForever);*/
    GetFileDir();
    sprintf(filenameAC,"%sAC.txt",filename);
    sprintf(pathAC,"%sAC.txt",filepath);
    pc.printf("\r\nFilename-AC\t%s", pathAC);
    FILE *fp = fopen(pathAC, "w");
    if(fp == NULL) {
        pc.printf("Could not open file for write\n\r");
        //reset_mod();
    } else {
        //pc.printf("attempting to save file\n\r");
        for(int k=0; k<dataLength; k++) {
            fprintf(fp, "%d.", ACdata[k]);
        }
        fprintf(fp, "EOF");
        fclose(fp);
    }
    sprintf(filenameDC,"%sDC.txt",filename);
    sprintf(pathDC,"%sDC.txt",filepath);
    pc.printf("\r\nFilename-DC\t%s", pathDC);
    fp = fopen(pathDC, "w");
    if(fp == NULL) {
        pc.printf("Could not open file for write\n\r");
        //reset_mod();
    } else {
        for(int k=0; k<dataLength; k++) {
            fprintf(fp, "%d.", DCdata[k]);
        }
        fprintf(fp, "EOF");
        fclose(fp);
    }
    sprintf(pathDCdetect,"%sData.txt",hour_dir);
    pc.printf("\r\nFilename-TC\t%s", pathDCdetect);
    fp = fopen(pathDCdetect, "w");
    if(fp == NULL) {
        pc.printf("Could not open file for write\n\r");
        //reset_mod();
    } else {
        fprintf(fp, "\r\n%s",time_stamp);
        for(int k=0; k<10; k++) {
            fprintf(fp, "\r\nDC-%d",DC_Detect_data[k]);
        }
        fclose(fp);
    }

    int avg_dc_detect=0;
    for(int i=0; i<10; i++) {
        avg_dc_detect=avg_dc_detect+int(DC_Detect_data[i]);
    }
    avg_dc_detect=avg_dc_detect/10;
    pc.printf("\r\nfftstart");

    //pc.printf("\r\nfftstage1");

    sprintf(filenamefft,"%sft.txt",filename);
    sprintf(pathfft,"%sft.txt",filepath);
    pc.printf("\r\nFilename-FFT\t%s", pathfft);
    fp = fopen(pathfft, "w");
    if(fp == NULL) {
        pc.printf("Could not open file for write\n\r");
        //reset_mod();
    } else {
        fprintf(fp, "\r\n%s",time_stamp);
        fprintf(fp, "\r\n DCDetect %d",avg_dc_detect);
        fclose(fp);
    }

    int fft_segments=4;
    int fft_start_index[4]= {0,760,1520,2280};
    int fft_points_count[4]= {4,120,240,360};
    int fft_maximas_required[4]= {1,20,8,8};
    //AC fft
    for(int i=0; i<fft_points; i++) {
        fft_array[i]=int(ACdata[i]);
        //pc.printf("%d %d %d\r\n", i, i+int(fft_points), fft_array[i]);
        fft_array[(i+int(fft_points))]=0;
    }
    fft(fft_points,0,1,1);
    pc.printf("\r\nfftdone");
    prepare_fft_array(fft_start_index,fft_points_count,fft_maximas_required,fft_segments,0);
    //DC fft
    for(int i=0; i<fft_points; i++) {
        fft_array[i]=int(DCdata[i]);
        //pc.printf("%d %d %d\r\n", i, i+int(fft_points), fft_array[i]);
        fft_array[(i+int(fft_points))]=0;
    }
    fft(fft_points,0,1,1);
    pc.printf("\r\nfftdone");
    prepare_fft_array(fft_start_index,fft_points_count,fft_maximas_required,fft_segments,1);
    pc.printf("storage done\r\n");
    //osSignalSet(tid6, 0x1);

    // }
}
//--------------------------------------------------------------------------------------------------//
//                 GSM Initialization                                                               //
//--------------------------------------------------------------------------------------------------//
void gsm_init()
{
    int cnt = 0;
    while((sendATcommand("AT+CREG?", "+CREG: 1,1", 5,0) || sendATcommand("AT+CREG?", "+CREG: 1,5", 5,0)) == 0) {
        if(sendATcommand("AT+CREG=1", "+CREG:1", 5,0)) {
            pc.printf("creg is 1");
            return;
        } else if(sendATcommand("AT+CREG=1", "+CREG:5", 5,0)) {
            pc.printf("creg is 5");
            return;
        }
        ++cnt;
        if(cnt == 4) {
            pc.printf("GSM registration failed");
            return;
        }
    }
}
//--------------------------------------------------------------------------------------------------//
//                 FTP Connect function                                                             //
//--------------------------------------------------------------------------------------------------//
bool ftp_connect()
{
    int ftp_connect_attempt=0;
    int ftp_close_attempt=0;
    sendATcommand("AT+CGATT=1", "OK", 10,0);
    /*if(sendATcommand("AT+SAPBR=2,1", "+SAPBR: 1,3,\"0.0.0.0\"", 5,0)) {
    } else {*/
    while(!sendATcommand("AT+SAPBR=2,1", "+SAPBR: 1,3,\"0.0.0.0\"", 5,0)) {
        sendATcommand("AT+SAPBR=0,1","OK",5,0);
        ftp_close_attempt++;
        if(ftp_close_attempt>3) {
            return 0;
        }
    }
    //}
    do{
        sendATcommand("AT+SAPBR=1,1", "OK", 10,0);
        ftp_connect_attempt++;
        if(ftp_connect_attempt>3){
            return 0;
            }
        }
    while(sendATcommand("AT+SAPBR=2,1", "+SAPBR: 1,3,\"0.0.0.0\"", 5,0));
    sendATcommand("AT+FTPTYPE=\"I\"", "OK", 5,0);
    sendATcommand("AT+FTPSERV=\"ftp.panchsheel.biz\"", "OK", 10,0);
    sendATcommand("AT+FTPUN=\"hardware@panchsheel.biz\"", "OK\r", 10,0);
    if(sendATcommand("AT+FTPPW=\"DAStest123\"", "OK\r", 10,0)) return 1;
    else return 0;
}

//--------------------------------------------------------------------------------------------------//
//                 FTP Send Function                                                                //
//--------------------------------------------------------------------------------------------------//

void ftp_put()
{
    char ftpfilename[30]="";
    char ftpfilepath[100]="";
      
    sprintf(ftpfilename,"%s",filenamefft);
    sprintf(ftpfilepath,"%s",pathfft);
    
    char command1[40];
    char result1[20];
    //char command2 [100];
    //char result2 [20];
   
    
    sprintf(command1,"%s\"%s\"", "AT+FTPPUTNAME=", ftpfilename);
    sprintf(result1,"%s", "OK");
    //pc.printf("ftpfilepath is \n\r %s \n\r",ftpfilepath);
   
   
    //sd card
    int char_cnt=0;
    char file_data[1294];
    FILE *fp8 = fopen(ftpfilepath, "r");
    if(fp8==NULL) {
        pc.printf("\n\r NULL Condition\r\n");
        return;
    } else {
        for(int i=0; i<1294; i++) {
            file_data[i] = fgetc(fp8);
            char_cnt= char_cnt++;
            if( feof(fp8) ) {
                break ;
            }
        }//size calculation loop ends
        fclose(fp8);
    }
    for(int putname_attempt=0; putname_attempt<2; putname_attempt++) {
        //pc.printf("\r\nftp_put attempt\n\r");
       
        if(sendATcommand(command1,result1, 10,0)) {
             //sprintf(command2,"%s\%s/\"", "AT+FTPPUTPATH=\"", filepath);
            // sprintf(result2,"%s", "OK");
             //sendATcommand(command2,result2, 10,0);
             //sendATcommand(command1,result1, 10,0);
             sendATcommand("AT+FTPPUTPATH=\"/NTF2/\"", "OK", 5,0);
             if(sendATcommand("AT+FTPPUT=1", "OK", 5,0)) {
                wait(8);
                int trialcount=0;
                int allowedtrials=3;
                char command[40];
                char result[30];
                sprintf(command,"%s%d", "AT+FTPPUT=2,",char_cnt);
                sprintf(result,"%s%d", "+FTPPUT:2,",char_cnt);
                while(trialcount<allowedtrials) {
                    if(sendATcommand(command,result, 10,0)) {
                        for(int i=0; i<char_cnt; i++) {
                            gsm.printf("%c", file_data[i]);

                        }
                        trialcount=allowedtrials+4;
                        wait(5);
                    } else trialcount++;
                }
            }
        }
        for(int ftp_close_attempt=0; ftp_close_attempt<2; ftp_close_attempt++) {
            pc.printf("\r\nftp_close\r\n");
            if(sendATcommand("AT+FTPPUT=2,0", "OK", 5,0)) {
                ftp_close_attempt=6;
            }
        }
        return;
    }
    
}
void FTP_Fun()
{
    /*tid6 = osThreadGetId();

    while(true)
    {
        osSignalWait(0x1, osWaitForever);*/
    if(ftp_connect()) {

        ftp_put();
        // downloadFTP();
    }
    return;
    //}
}


int main()
{
       
    gsm_rst=0;
    wait(3);
    gsm_rst=1;
    wait(5);
    mkdir("/sd/jas",0777);
    int loop_count=0;
    pc.printf("\r\nHelloWorld\r\n");
    sendATcommand("AT+CLTS=1\r", "OK", 5,0);
    wait(2);
    GetFileDir();
    FILE *fp = fopen("/sd/SiteInfo.txt","a");
    if(fp == NULL) {
        FILE *fp = fopen("/sd/SiteInfo.txt","w");
        fprintf(fp, "\r\n%s",time_stamp);

    } else {
        fprintf(fp, "\r\n%s",time_stamp);
        pc.printf("\r\n%s",time_stamp);
        fclose(fp);
    }
    pc.printf("\r\n Timestamp saved");
    while(1) {
        sampling();
        store();
        FTP_Fun();
        loop_count++;
        if(loop_count%120==0) {
            loop_count=0;
            reset_mod();
        }
        //wait(10);
    }
    //fft(16384,0,1,1);
    //prepare_fft_array(fft_start_index,fft_points_count,fft_maximas_required,fft_segments);
}