#include "Player.h"

Player::Player(int x, int y, uLCD_4DGL *uLCD) {
    _health = 4;
    _x = x;
    _y = y;
    _uLCDptr = uLCD;
    _cockpit.init(0,0,uLCD);
    _cockpit.setRadius(6);
    _glare.init(1,-2,uLCD);
    _glare.setRadius(2);
    _body.init(-4,0,uLCD);
    _body.setDimensions(16,8);
    _leftWing.init(-14,11,uLCD);
    _leftWing.setDimensions(4,10);
    _rightWing.init(4,11,uLCD);
    _rightWing.setDimensions(4,10);
    _leftGun.init(-11,9,uLCD);
    _leftGun.setDimensions(2,4);
    _rightGun.init(8,9,uLCD);
    _rightGun.setDimensions(2,4);
    _engine1.init(-2,16,uLCD);
    _engine1.setDimensions(2,3);
    _engine2.init(-3,16,uLCD);
    _engine2.setDimensions(5,6);
    _healthBar.init(-10, -10,uLCD);
    _healthBar.setDimensions(1,20);
}

void Player::addX(int dx) {
    if((dx > 0) && (_x + 14 <= 128)) {
        _x += dx;
    }
    if((dx < 0) && (_x - 14 >= 0)) {
        _x += dx;
    }
}

void Player::addY(int dy) {
    if((dy > 0) && (_y + 21 <= 128)) {
        _y += dy;
    }
    if((dy < 0) && (_y - 3 >= 0)) {
        _y += dy;    
    }
}

Point Player::hitBoxStart() {
    Point hitStart;
    hitStart.x = _x - 3;
    hitStart.y = _y - 3;
    return hitStart;
}

Point Player::hitBoxDim() {
    Point hitDim;
    hitDim.x = 8;
    hitDim.y = 24;
    return hitDim;
}

Point Player::getLeftGunLoc() {
    Point gunLoc;
    gunLoc.x = _x - 10;
    gunLoc.y = _y + 9;
    return gunLoc;
}

Point Player::getRightGunLoc() {
    Point gunLoc;
    gunLoc.x = _x + 9;
    gunLoc.y = _y + 9;
    return gunLoc;
}

void Player::drawPlayer() {
    _engine2.drawRect(_x,_y,Engine1Color);
    _engine1.drawRect(_x,_y,Engine2Color);
    _leftGun.drawRect(_x,_y,GunColor);
    _rightGun.drawRect(_x,_y,GunColor);
    _leftWing.drawRect(_x,_y,WingColor);
    _rightWing.drawRect(_x,_y,WingColor);
    _body.drawRect(_x,_y,BodyColor);
    _cockpit.drawCircle(_x, _y, CockpitColor);
    _glare.drawCircle(_x,_y,GlareColor);
    if(_health == 4) {
        _healthBar.setDimensions(1,20);
    }
    else if(_health == 3) {
        _healthBar.setDimensions(1,15);
    }
    else if(_health == 2) {
        _healthBar.setDimensions(1,10);
    }
    else if(_health == 1) {
        _healthBar.setDimensions(1,5);
    }
    else {
        _healthBar.setDimensions(1,1);
    }
    _healthBar.drawRect(_x,_y, HealthColor);
}

void Player::damage(int dmg) {
    _health -= dmg;    
}

int Player::getHealth() {
    return _health;    
}