 #include "Enemy.h"
 
Enemy::Enemy(int x, uLCD_4DGL *uLCD) {
    _health = 2;
     _x = x;
    _y = -10;
    _uLCDptr = uLCD;
    _cockpit.init(0,0,uLCD);
    _cockpit.setRadius(10);
    _glare1.init(3,3,uLCD);
    _glare1.setRadius(4);
    _glare2.init(-3,-3,uLCD);
    _glare2.setRadius(3);
    _gun.init(0,10,uLCD);
    _gun.setDimensions(4,2);
    _engine.init(-2,-15,uLCD);
    _engine.setDimensions(5,5);
    _healthBar.init(-9, 16,uLCD);
    _healthBar.setDimensions(1,20);
}

void Enemy::drawEnemy() {
    _cockpit.drawCircle(_x, _y, EnemyCockpitColor);
    _glare1.drawCircle(_x, _y, EnemyGlareColor1);
    _glare2.drawCircle(_x, _y, EnemyGlareColor2);
    _gun.drawRect(_x, _y, EnemyGunColor);
    _engine.drawRect(_x, _y, EnemyEngineColor);
    if(_health == 2) {
        _healthBar.setDimensions(1,20);
    }
    else if(_health == 1) {
        _healthBar.setDimensions(1,10);
    }
    else {
        _healthBar.setDimensions(1,1);
    }
    _healthBar.drawRect(_x,_y, HealthColor);
}

void Enemy::addY(int dy) {
    _y += dy;
}

int Enemy::getY() {
    return _y;    
}

Point Enemy::hitBoxStart() {
    Point hitStart;
    hitStart.x = _x - 11;
    hitStart.y = _y - 11;
    return hitStart;
}

Point Enemy::hitBoxDim() {
    Point hitDim;
    hitDim.x = 21;
    hitDim.y = 21;
    return hitDim;
}

Point Enemy::getGunLoc() {
    Point gunLocation;
    gunLocation.x = _x;
    gunLocation.y = _y + 5;
    return gunLocation;
}

void Enemy::damage(int dmg) {
    _health -= dmg;    
}

int Enemy::getHealth() {
    return _health;    
}