#ifndef ENEMY_H
#define ENEMY_H

#define EnemyCockpitColor 0x3300FF
#define EnemyGlareColor1 0x330000
#define EnemyGlareColor2 0xCC3300
#define EnemyGunColor 0xCCCCCC
#define EnemyEngineColor 0xFFFFFF
#define HealthColor 0xFF0000

#include "mbed.h"
#include "Circle.h"
#include "Rectangle.h"
#include "Point.h"

class Enemy {
public:
    void fireToggle();
    Enemy(int x, uLCD_4DGL *uLCD);
    void drawEnemy();
    void addY(int dy);
    void damage(int dmg);
    int getY();
    int getHealth();
    Point hitBoxStart();
    Point hitBoxDim();
    Point getGunLoc();

    
private:
    int _x;
    int _y;
    int _health;

    Circle _cockpit;
    Circle _glare1;
    Circle _glare2;
    Rectangle _gun;
    Rectangle _engine;
    Rectangle _healthBar;
    uLCD_4DGL *_uLCDptr;
};

#endif
