#ifndef PLAYER_H
#define PLAYER_H

#define CockpitColor 0x660000
#define GlareColor 0x666666
#define BodyColor 0x999999
#define WingColor 0x333333
#define GunColor 0xB50000
#define Engine1Color 0xFF3300
#define Engine2Color 0xFFFF00
#define HealthColor 0xFF0000

#include "mbed.h"
#include "Circle.h"
#include "Rectangle.h"
#include "Point.h"

class Player {
public:
    Player(int x, int y, uLCD_4DGL *uLCD);
    void drawPlayer();
    void addX(int dx);
    void addY(int dy);
    Point hitBoxStart();
    Point hitBoxDim();
    Point getLeftGunLoc();
    Point getRightGunLoc();
    void damage(int dmg);
    int getHealth();
    
private:
    int _x;
    int _y;
    int _health;
    Circle _cockpit;
    Circle _glare;
    Rectangle _body;
    Rectangle _leftWing;
    Rectangle _rightWing;
    Rectangle _leftGun;
    Rectangle _rightGun;
    Rectangle _engine1;
    Rectangle _engine2;
    Rectangle _healthBar;
    uLCD_4DGL *_uLCDptr;
};

#endif
