#include "mbed.h"
#include "uLCD_4DGL.h"
#include "Player.h"
#include "Enemy.h"
#include "PinDetect.h"
#include "Circle.h"
#include "Shot.h"
#include "Point.h"
#include "Star.h"
#include <vector>

#define PlayerShotColor 0xFF0000
#define EnemyShotColor 0x00FF00

class Nav_Switch
{
public:
    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
    int read();
//boolean functions to test each switch
    bool up();
    bool down();
    bool left();
    bool right();
    bool fire();
//automatic read on RHS
    operator int ();
//index to any switch array style
    bool operator[](int index) {
        return _pins[index];
    };
private:
    BusIn _pins;
 
};
Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
    _pins(up, down, left, right, fire)
{
    _pins.mode(PullUp); //needed if pullups not on board or a bare nav switch is used - delete otherwise
    wait(0.001); //delays just a bit for pullups to pull inputs high
}
inline bool Nav_Switch::up()
{
    return !(_pins[0]);
}
inline bool Nav_Switch::down()
{
    return !(_pins[1]);
}
inline bool Nav_Switch::left()
{
    return !(_pins[2]);
}
inline bool Nav_Switch::right()
{
    return !(_pins[3]);
}
inline bool Nav_Switch::fire()
{
    return !(_pins[4]);
}
inline int Nav_Switch::read()
{
    return _pins.read();
}
inline Nav_Switch::operator int ()
{
    return _pins.read();
}

Nav_Switch myNav( p24, p22, p23, p21, p13);
uLCD_4DGL uLCD(p28, p27, p29);
Player player(60,100,&uLCD);
Ticker switchScreen;
Ticker setCanShoot;
Ticker spawnEnemy;
Ticker enemyShoot;
Ticker spawnStar;
PinDetect pbFire(p25);
int playerSpeed = 8;
int enemySpeed = 4;
int shotSpeed = 8;
int enemyShotSpeed = 8;
int numShots = 0;
int numEnemyShots = 0;
int canShoot = 1;
int numEnemies = 0;
int numStars = 0;
int gameOver = 0;
std::vector<Shot> playerShots;
std::vector<Shot> enemyShots;
std::vector<Enemy> enemies;
std::vector<Star> stars;


void changeScreen() {
    uLCD.media_init();
    uLCD.set_sector_address(0x0000, 0x0041);
    uLCD.display_image(0,0);
}

void setShoot() {
    canShoot = 1;    
}

void fire(void) {
    if(canShoot) {
        Point leftShot = player.getLeftGunLoc();
        Point rightShot = player.getRightGunLoc();
        Shot shot1(leftShot.x, leftShot.y, -shotSpeed, PlayerShotColor, &uLCD);
        Shot shot2(rightShot.x, rightShot.y, -shotSpeed, PlayerShotColor, &uLCD);
        playerShots.push_back(shot1);
        playerShots.push_back(shot2);
        numShots += 2;
        canShoot = 0;
        setCanShoot.attach(&setShoot, 0.6);
    }
}

void spawnNewEnemy() {
    Enemy e((int)(((float) rand() / (RAND_MAX))*127), &uLCD);
    enemies.push_back(e);
    numEnemies++;
    spawnEnemy.attach(&spawnNewEnemy, ((float) rand() / (RAND_MAX))*5);
}

void enemiesFire() {
   for(int j=numEnemies-1; j>=0; j--) {
       Point firePoint = enemies[j].getGunLoc();
       Shot enemyShot(firePoint.x, firePoint.y, enemyShotSpeed, EnemyShotColor, &uLCD);
       enemyShots.push_back(enemyShot); 
       numEnemyShots++;
    }
    enemyShoot.attach(&enemiesFire, 3.0);
}

void checkPlayerShotCollision() {
    for(int i=numShots-1; i>=0; i--) {
        for(int j=numEnemies-1; j>=0; j--) {
            Point hitStart = enemies[j].hitBoxStart();
            Point hitBounds = enemies[j].hitBoxDim();
            if(playerShots[i].getX() > hitStart.x && playerShots[i].getX() < hitStart.x + hitBounds.x) {
                if(playerShots[i].getY() > hitStart.y && playerShots[i].getY() < hitStart.y + hitBounds.y) {
                        enemies[j].damage(1);
                        playerShots.erase(playerShots.begin() + i);
                        numShots--;
                        if(enemies[j].getHealth() <= 0) {
                             enemies.erase(enemies.begin() + j);
                             numEnemies--;
                        }
                }
            }
       } 
    }  
}

void checkEnemyShotCollision() {
    for(int k=numEnemyShots-1; k>=0; k--) {
        Point hitStart = player.hitBoxStart();
        Point hitBounds = player.hitBoxDim();
        if(enemyShots[k].getX() > hitStart.x && enemyShots[k].getX() < hitStart.x + hitBounds.x) {
            if(enemyShots[k].getY() > hitStart.y && enemyShots[k].getY() < hitStart.y + hitBounds.y) {
                    player.damage(1);
                    enemyShots.erase(enemyShots.begin() + k);
                    numEnemyShots--;
                    if(player.getHealth() <= 0) {
                         gameOver = 1;
                         uLCD.media_init();
                         uLCD.set_sector_address(0x0000, 0x0082);
                         uLCD.display_image(0,0);
                    }
            }
        }
    }
}

void createStar() {
    Star star1(&uLCD);
    stars.push_back(star1);
    Star star2(&uLCD);
    stars.push_back(star2);
    numStars += 2;
    spawnStar.attach(&createStar, 1.0);
}

int main() {
    uLCD.media_init();
    uLCD.set_sector_address(0x0000, 0x0000);
    uLCD.display_image(0,0);
    wait(2);
    pbFire.mode(PullUp);
    wait(.01);
    pbFire.attach_deasserted(&fire);
    pbFire.setSampleFrequency();
    spawnNewEnemy();
    enemyShoot.attach(&enemiesFire, 2.0);
    createStar();
    uLCD.baudrate(3000000);
    while(1) {
       if(gameOver) {
           break;    
       }  
       if(myNav.up()) {
           player.addY(-playerSpeed);
       }
       else if(myNav.down()) {
           player.addY(playerSpeed);
       }
       if(myNav.left()) {
           player.addX(-playerSpeed);
       }
       else if(myNav.right()) {
           player.addX(playerSpeed);
       }
       uLCD.filled_rectangle(0, 0, 128, 128,  0x000000);
       player.drawPlayer();
       for(int i=numShots-1; i>=0; i--) {
           playerShots[i].update();
           if(playerShots[i].getY() < 0) {
               playerShots.erase(playerShots.begin() + i);
               numShots--;
           } 
       }
       for(int k=numEnemyShots-1; k>=0; k--) {
           enemyShots[k].update();
           if(enemyShots[k].getY() > 128) {
               enemyShots.erase(enemyShots.begin() + k);
               numEnemyShots--;
           } 
       }
       for(int j=numEnemies-1; j>=0; j--) {
           enemies[j].addY(enemySpeed);
           enemies[j].drawEnemy();
           if(enemies[j].getY() > 140) {
               enemies.erase(enemies.begin() + j);
               numEnemies--;
           }
       }
       for(int n=numStars-1; n>=0; n--) {
           if(stars[n].offScreen()) {
               stars.erase(stars.begin() + n);
               numStars--;    
           }   
           stars[n].update(); 
       }
       checkPlayerShotCollision();
       checkEnemyShotCollision();
       wait(.1);
    }
}
