#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "GameEngine.h"

#define PI 3.14159265
//Y rows and X columns
#define Rows 48
#define Cols 84

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
AnalogIn brightness(PTB2);
Gamepad pad;
GameEngine game;

int gamefps = 15;

Ticker waveCompleteTicker; 
int Start_The_Game_flag;
int waveComplete_flag;
int waveNumber;
int menu;

char wave[10];

void init();
void render();
void waveComplete_isr();
void gameMenu();
void startGame();
void gameUpgrades();

int main()
{
    init();
    game.gameMenu_flag = 1;
    while (true) {
        if (game.gameMenu_flag == 1) {
            gameMenu();
            Start_The_Game_flag = 1; //set the startgame flag
            game.gameMenu_flag = 0; //remove flag
        }
        if (Start_The_Game_flag == 1 || game.retry_flag == 1) {  
            game.retry_flag = 0; //clear flag
            startGame();
        }
        lcd.setBrightness(brightness);
        
        //this is the game
        game.update(pad, lcd); 
        
        while (waveComplete_flag == 1) { //after every wave, go to upgrades
            gameUpgrades();
        }
        render();
    }
}

void init() {
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
    game.init(waveNumber);
    // initialise the game
}
void render() {
    // clear screen, re-draw and refresh
    lcd.refresh();
    wait(1.0/gamefps);
    lcd.clear(); 
}
void startGame() {
    sprintf(wave, "wave %d", waveNumber + 1); //+1 because initially waveNumber = 0
    lcd.printString(wave,10,3);
    render();
    wait(2.0);
    game.init(waveNumber);
    game.update_MainToRetry(); //save the game state at the start of each wave
    waveCompleteTicker.attach(&waveComplete_isr,60); //60 seconds for a wave.
    Start_The_Game_flag = 0; //clear set ticker flag
    if (pad.check_event(Gamepad::START_PRESSED)) { 
        //printf("start double click prevented");
    }
}
void gameUpgrades() {
    waveCompleteTicker.detach();
    lcd.printString("Wave complete",1,2);
    lcd.printString("Press start to",1,4);
    lcd.printString("upgrade",30,5);
    render();
    game.weapUpgrade(pad, lcd);
    
    if (game.doneUpgrade_flag == 1) {
        waveComplete_flag = 0; //get out of while loop
        Start_The_Game_flag = 1; //continue the game
        game.doneUpgrade_flag = 0;
        //printf("i got out");
    }
}
void waveComplete_isr() {
    waveComplete_flag = 1;
    waveNumber += 1;
}
void gameMenu() {
    waveNumber = 0;
    game.reset_Game();
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        game.startingMenu(pad, lcd);
        lcd.refresh();
        wait(0.2);
    }
    lcd.clear();
}