#include "GameEngine.h"

GameEngine::GameEngine()
{

}

GameEngine::~GameEngine()
{

}
void GameEngine::startingMenu(Gamepad &pad, N5110 &lcd) {
    _gui.startingMenu(lcd);
    ledNumber ++;
    pad.led(ledNumber, 1.0);
    pad.led(ledNumber - 1, 0.0);
    if (ledNumber == 6) {
        ledNumber = 0;    
    } else {
        pad.led(6, 0.0);    
    } 
    _gui.preventDoubleClick(pad);
    
}
void GameEngine::init(int w) {
    NumberOfLife = 3; //3 life on every wave
    weap.init();
    _d1.droneInit(20, 46, 0, 42, weap._droneDamage, weap._droneRange); //drone1 is taking left side pixel 0 to 42.
    _d2.droneInit(62, 46, 42, 84, weap._droneDamage, weap._droneRange); //drone2 is taking right side pixel 42 to 83;
    spa.init(w);
    //printf("init completed \n");
}
void GameEngine::update(Gamepad &pad, N5110 &lcd) {
    weap.init();
    _d1.drone_main(scnd.Arr, scnd.cArr, lcd);
    _d2.drone_main(scnd.Arr, scnd.cArr, lcd);
    drawSpawn(lcd); 
    laser_and_cannon(pad, lcd);
    bomb_And_Shield(pad, lcd);
    checkGameRule(pad, lcd);
    //_gui.preventDoubleClick(pad);
}
void GameEngine::weapUpgrade(Gamepad &pad, N5110 &lcd) {
    if (pad.check_event(Gamepad::START_PRESSED)) { 
        _gui.upgrading_flag = 1;
        _gui.preventDoubleClick(pad);
        while (_gui.upgrading_flag == 1) {
            //printf("laserDamage = %i \n",weap._laserDamage);
            //go to the upgrade page with all the values (from Weapon) as reference.
            _gui.upgrades(weap._laserDamage, weap._bombDamage, weap._bombRange, weap._bombCooldown, weap._droneDamage, weap._droneRange, weap._shieldCapacity, weap._shieldRegenRate, weap._cannonDamage, weap._cannonCapacity, weap._cannonRegenRate, pad, lcd); 
            //printf("_gui.saveTheData = %d",_gui.saveTheData);
            if (_gui.saveTheData_flag == 1) {
                Data _upgrades = _gui.get_data(); //saving data
                //_gui.testingtest(_upgrades);  //code used to test the struct
                weap.setVar(_upgrades.up, _upgrades.up1);
                weap.setVar(_upgrades.u1p, _upgrades.u1p1);
                //printf("TESTING up = %d, up1 = %d, u1p = %d, u1p1 = %d \n",_upgrades.up,_upgrades.up1,_upgrades.u1p,_upgrades.u1p1); 
                _gui.saveTheData_flag = 0;
                _gui.upgrading_flag = 0; //get out of while loop after done upgrading
            }
            lcd.refresh();
            wait(0.2);
            lcd.clear();
        } 
        doneUpgrade_flag = 1;
        //remember to re-initialise everything after a wave.
    }
}
void GameEngine::drawSpawn(N5110 &lcd){
    updateArray(); //clean up & update the main.Arr after the spawn took damage.
    if (drawit == 0) { 
        drawit = 30;
        spa.summon_spawn(main.Arr, main.cArr);//summon spawn when drawit == 0 
        spa.moveSpawnABC(main.Arr, scnd.Arr, main.cArr, scnd.cArr);
        spa.moveSpawnDE(main.Arr, scnd.Arr, main.cArr, scnd.cArr);
        //printf("why u do this to cannonFiring_flag?? cannonFiring_flag = %d \n",weap.cannonFiring_flag);
        if ( fireInTheHole_flag ==1) { //this code because whenever spawn ABCDE moves, weap.cannonFiring_flag goes to 0 automatically (NO IDEA WHY)
            weap.cannonFiring_flag = 1;    
        }
    } else {
        drawit -= 0.5;
        spa.moveSpawnDE(main.Arr, scnd.Arr, main.cArr, scnd.cArr);
        spa.moveSpawnB(main.Arr, scnd.Arr, main.cArr, scnd.cArr);
        //printf("moving spawn b \n");
    }
    spa.updateSpawn(main.Arr, scnd.Arr, main.cArr, scnd.cArr, lcd); 
}
void GameEngine::laser_and_cannon(Gamepad &pad, N5110 &lcd) {
    weap.drawPlayer(pad, lcd);
    weap.cannon_recharge();
    weap.cannon_Meter(lcd);
    //draw a line for the laser when button is pressed
    if (pad.buttonhold_A == 1) {
        //printf("hi, button is working \n");
        weap.weaponMath(pad);
        weap.laser_Main(scnd.Arr, scnd.cArr, lcd);
        
        //cannon can only be fired when the laser is switched on.
        if ( weap._cannon > 320) { //when sufficient, check for button Y.
            if ( pad.check_event(Gamepad::Y_PRESSED)) { //press button to set flag (fire the cannon)
                fireInTheHole_flag = 1; 
            }
        }
    }
    if ( fireInTheHole_flag == 1) { //if flag toggled 
        weap.cannon_main(scnd.Arr, scnd.cArr, lcd);    
    }
    if ( weap.cannonFiring_flag == 0) { //clear flag when cannon is done 
        fireInTheHole_flag = 0;
    }
}
void GameEngine::checkGameRule(Gamepad &pad, N5110 &lcd) {
    //the only way to lose a life is when a spawn reaches y = 46.
    numberOfLife_leds(pad);
    for ( int x = 0; x < 84; x ++) {
        if (main.Arr[x][46] > 0) { //if anything reaches line y=46
            NumberOfLife --;
            pad.tone(750.0,0.5);
            //printf("opps you lost a life. NumberOfLife = %d \n",NumberOfLife);
            if (NumberOfLife == 0) {
                gameOver(pad, lcd);
            }
        }
    }       
}
void GameEngine::gameOver(Gamepad &pad, N5110 &lcd) {
    while (retry_flag == 0 && gameMenu_flag == 0) { //while both are 0
        lcd.clear();
        lcd.printString("Game Over",10,3);
        lcd.printString("GiveUp   Retry",0,5);
        lcd.refresh();   
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
        //printf("press a button pls. you lost retry_flag = %d gameMenu_flag = %d\n",retry_flag,gameMenu_flag);
        //must click atleast one button to continue
        if (pad.check_event(Gamepad::START_PRESSED)) {
            retry_flag = 1;
            printf("retry pressed \n");
            update_RetryToMain();
        }
        if (pad.check_event(Gamepad::BACK_PRESSED)) {
            gameMenu_flag = 1; //bring the player to game menu
            printf("player surrendered \n");
        }  
                      
    } 
}
void GameEngine::numberOfLife_leds(Gamepad &pad) { 
    //light up LEDs depends on number of lifes left.
    if (NumberOfLife == 3) {
        pad.leds_on(); //turn on all leds
    }
    if (NumberOfLife == 2) {
        pad.led(1, 1.0); //turn on led 1, 2, 5 and 6
        pad.led(2, 1.0);
        pad.led(3, 0.0);
        pad.led(4, 0.0);
        pad.led(5, 1.0);
        pad.led(6, 1.0);
    }
    if (NumberOfLife == 1) {
        pad.led(1, 1.0); //turn on led 1 and 6
        pad.led(2, 0.0);
        pad.led(3, 0.0);
        pad.led(4, 0.0);
        pad.led(5, 0.0);
        pad.led(6, 1.0);   
    }
}
void GameEngine::bomb_And_Shield(Gamepad &pad, N5110 &lcd) { 
    weap.bomb_main(scnd.Arr, pad, lcd);
    if (pad.check_event(Gamepad::X_PRESSED)) {
        //to prevent from detonating the bomb at instant when button X is accidentally pressed 
        //printf("instant bomb detonate prevented");
    }
    weap.shield_main(scnd.Arr, scnd.cArr, pad, lcd);
    if (pad.check_event(Gamepad::B_PRESSED)) {
        //to prevent the button from clicking twice
        printf("shield double click prevented");
    }
}
void GameEngine::updateArray() { //update main array with secondary array and clean up the array
    for (int x = 0; x < Cols; x++) {
        for (int y = 0; y < Rows; y++) {
            main.Arr[x][y] = scnd.Arr[x][y];
            //printf(" main.Arr[%d][%d] = %d \n",x,y,scnd.Arr[x][y]);
            spa.deleteChar(x, y, main.Arr, scnd.cArr);
        }
    }    
}
void GameEngine::update_MainToRetry() { //update Retry array with main array
    for (int x = 0; x < Cols; x ++) {
        for (int y = 0; y < Rows; y ++) {
            retry.Arr[x][y] = main.Arr[x][y];
            retry.cArr[x][y]= main.cArr[x][y];
        }
    }  
    printf("main to retry array updated \n");  
}
void GameEngine::update_RetryToMain() {//update main & secondary array with Retry array
    for (int x = 0; x < Cols; x ++) {
        for (int y = 0; y < Rows; y ++) {
            main.Arr[x][y] = retry.Arr[x][y];
            main.cArr[x][y] = retry.cArr[x][y];
            scnd.Arr[x][y] = retry.Arr[x][y];
            scnd.cArr[x][y] = retry.cArr[x][y];
        }
    }  
    printf("retry to main array updated \n");
}
void GameEngine::reset_Game() { //reset everything in the game
    for (int x = 0; x < Cols; x ++) {
        for (int y = 0; y < Rows; y ++) { //clear array
            main.Arr[x][y] = 0;
            main.cArr[x][y] = '\0';
            scnd.Arr[x][y] = 0;
            scnd.cArr[x][y] = '\0';
        }
    }  
    weap.reset_WeaponVariables(); //clear weapon variables
}