#ifndef GUI_H
#define GUI_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Weapon.h"
#include "Spawn.h"

//position of cursor
struct Cursors {
    int number_y;   
    int number_x;
};

//struct to store the ugprade data
struct Data {
    int up;
    int up1;
    int u1p;
    int u1p1;
};

/** GUI Class
@brief User interface class for the game 
@author JianWei Lee
@date April 2017
*/
class GUI 
{

    
public: 
    GUI();
    ~GUI();
    
    /**Starting Menu Strings
    *
    *Few strings to be printed on the lcd before starting the game
    */
    void startingMenu(N5110 &lcd);
    

    /**Weapon Upgrades
    *
    *@brief 2 points will be given for upgrades\n
    *@brief Start button to enter the upgrade page\n
    *@brief Press button A to select\n
    *@brief After spending 2 points, press Start button again to continue game\n
    *@param a - laser damage
    *@param b - bomb damage
    *@param c - bomb radius
    *@param d - bomb cooldown
    *@param e - drone damage
    *@param f - drone range
    *@param g - shield capacity
    *@param h - sheild regenerative rate
    *@param i - cannon damage
    *@param j - cannon capacity
    *@param k - cannon regenerative rate
    */
    void upgrades(int a, int b, int c, int d, int e, int f, int g, int h, int i, int j, int k, Gamepad &pad, N5110 &lcd);
    
    /**Prevent pad double click
    *
    *@brief Double clicking always happens on the pad and it breaks the game \n
    *@brief Clear off the event flag for unintended clicks
    */
    void preventDoubleClick(Gamepad &pad);
    
    /**Get Upgrades Data
    *
    *@brief The weapon that is upgraded will be saved in the struct Data using numbers \n
    *@brief Return weapon's number and variable's number.
    */
    Data get_data();
    
    int upgrading_flag;
    int upgrading1_flag;
    int saveTheData_flag;
    

private:
    
    int cc;
    int options;
    char pointsRemaining[10];
    char upgrade1[12];
    char upgrade2[12];
    char upgrade3[12];
    
    
    
    int pointsUpgrade;
    int pointsGiven;
    int upgradePicked;
    int upgradePicked1;
    int upgrade1Picked;
    int upgrade1Picked1;
    
    //function to move the cursor up and down
    Cursors cursor(Gamepad &pad);
    int cursor_y;
    int cursor_y1;
    //simply draw a square cursor depends on the cursor Y position
    void drawCursor(int Cy, N5110 &lcd);
    
    //contains printstring in all the page
    void main_UpgradesPage(N5110 &lcd);
    void laser_UpgradesPage(int laserDamage, N5110 &lcd);
    void bomb_UpgradesPage(int bombDamage, int bombR, int bombCooldown, N5110 &lcd);
    void drone_UpgradesPage(int droneDamage, int droneRange, N5110 &lcd);
    void shield_UpgradesPage(int shieldCapacity, int shieldRegenRate, N5110 &lcd);
    void cannon_UpgradesPage(int cannonDamage, int cannonCapacity, int cannonRegenRate, N5110 &lcd);
    
    //save the upgrade data for later use in Weapon library
    //and manage the upgrade points
    void upgradesData(Gamepad &pad);
    
    //this to check the buttons pressed when upgrading weapon and play tone to notify player
    void pad_events(Gamepad &pad);

};

#endif