#include "Spawn.h"

Spawn::Spawn()
{

}

Spawn::~Spawn()
{

}
void Spawn::init(int w) {
    A.health = 8 + 4 * w;
    A.spawnRate = 47 + w;
    B.health = 1000; //health B wont change
    B.spawnRate = 1 + w / 2;
    C.health = 170 + w * 15;
    C.spawnRate = 2 + w;
    DE.health = 20 + 2 * w;
    DE.spawnRate = 1 + w / 2;
    //randomise the seed. To get different spawn pattern all the time.
    int t = time(NULL);
    //printf("t = %d \n",t);
    srand(t); 
}
void Spawn::summon_spawn(int Arr[][Rows], char cArr[][Rows]) {
        //there is 4 kind of different spawn - a, b, c and d/e.
        if (stopSpawnA == 1) { //spawn spawnA for this row
            spawnA(Arr, cArr);
            stopSpawnA= 0;
        } else { //spawn spawnC for this next row
            stopSpawnA = 1;
            spawnC(Arr, cArr);
        }
        for ( int x = 0; x < Cols; x++) {
            spawnB(x, Arr, cArr);
            spawnDE(x, Arr, cArr);
        }
        //printf("at x=2, y=0. value = %d \n",Arr1[2][0]);
}
void Spawn::spawnA(int Arr[][Rows],char cArr[][Rows]) {
    for ( int x = 0; x < Cols; x++) {
        //35/220 chance of spawning for A.
        //depends on wave number
        bool TrueFalseA = (rand() % 220) < A.spawnRate;
        if (TrueFalseA) {
            //spawning from the top of the screen
            Arr[x][0] = A.health;
            cArr[x][0] = 'a';
            //printf("spawn set at x = is %d \n",x);
        }
    }    
}
void Spawn::spawnB(int x, int Arr[][Rows],char cArr[][Rows]) {
    bool TrueFalseB = (rand() % 220) < B.spawnRate;
    if (TrueFalseB) {
        Arr[x][0] = B.health;
        cArr[x][0] = 'b';
    }
}
void Spawn::spawnC(int Arr[][Rows],char cArr[][Rows]) {
    for ( int x = 0; x < Cols; x++) {
    bool TrueFalseC = (rand() % 220) < C.spawnRate;
        if (TrueFalseC) {
            Arr[x][1] = C.health;
            cArr[x][1] = 'c';
            cArr[x-1][0] = 'l'; //l and r given to spawn C to give it a bigger hit box for laser 
            cArr[x+1][0] = 'r';
        }
    }
}
void Spawn::spawnDE(int x, int Arr[][Rows], char cArr[][Rows]) {
    bool TrueFalseD = (rand() % 220) < DE.spawnRate;
    if (TrueFalseD) {
        bool LeftRightD = (rand() % 10) <5; //its a 50-50 chance 
        if (LeftRightD) {
            Arr[x][0] = DE.health;
            cArr[x][0] = 'd'; //d denotes spawnD starts by moving left
        } else {
            Arr[x][0] = DE.health;
            cArr[x][0] = 'e'; //e denotes spawnD starts by moving right          
        }
    }
}
void Spawn::moveSpawnABC(int Arr[][Rows], int Arr2[][Rows], char cArr[][Rows], char cArr2[][Rows]) {
    //printf("x=2,y =0. value = %d \n",array[2][0]);
    //scan through the whole array
    for (int x = 0; x < Cols; x++) {
        for (int y = 0; y < Rows; y++) {
            if (cArr[x][y] == 'a' || cArr[x][y] == 'b' || cArr[x][y] == 'c' || cArr[x][y] == 'l' || cArr[x][y] == 'r' || cArr[x][y] == 'm') {
                Arr2[x][y+1] = Arr[x][y]; cArr2[x][y+1] = cArr[x][y]; //move everything down a row
            } else {
                Arr2[x][y+1] = 0; cArr2[x][y+1] = '\0';
            }
        }
    }
    printf("at x=2, y=47. number is =%d \n",Arr2[2][47]);  
}
void Spawn::moveSpawnDE(int Arr[][Rows], int Arr2[][Rows], char cArr[][Rows], char cArr2[][Rows]) { 
    for (int x = 0; x < Cols; x++) {                                                               
        for (int y = 0; y < Rows; y++) {                                                           
            if (cArr[x][y] == 'd') { //d = move left & down
                movementD(x, y, Arr, Arr2, cArr, cArr2);       
            } else if ( cArr[x][y] == 'e') { //e = move right & down
                movementE(x, y, Arr, Arr2, cArr, cArr2);
            }
        }
    }        
}
void Spawn::movementD(int x, int y, int Arr[][Rows], int Arr2[][Rows], char cArr[][Rows], char cArr2[][Rows]) { //d = move left & down
    if (cArr[x-1][y+1] == 'a' || cArr[x-1][y] == 'b' ) { //if the path is blocked by spawnA or spawnB 
        cArr2[x-2][y+2] = 'd'; Arr2[x-2][y+2] = Arr[x][y]; //jumps over it
        cArr2[x][y] = '\0'; Arr2[x][y] = 0;
        //printf("jump over at [%d][%d] \n",x-1,y+1);
    } else if (x == 0 || x == 83 || cArr[x-1][y+1] == 'l' || cArr[x-1][y+1] == 'r' || cArr[x-1][y+1] == 'm') { //if it hits the wall or 'l' or 'r' or 'm'.
        if (cArr[x-1][y+1] == 'l' || cArr[x-1][y+1] == 'r') {
            //printf("char = %c \n",cArr[x-1][y+1]);
        }
        cArr2[x+1][y+1] = 'e'; Arr2[x+1][y+1] = Arr[x][y]; //start moving right & down (change direction)
        cArr2[x][y] = '\0'; Arr2[x][y] = 0;
        //printf("spawn d at x = %d is shifted to e \n",x);
    } else { //if nothing is blocking the path
        cArr2[x-1][y+1] = cArr[x][y]; Arr2[x-1][y+1] = Arr[x][y]; //move as usual.
        cArr2[x][y] = '\0'; Arr2[x][y] = 0;
        //printf("work pls. \n");
    }
}
void Spawn::movementE(int x, int y, int Arr[][Rows], int Arr2[][Rows], char cArr[][Rows], char cArr2[][Rows]) {  //e = move right & down
    if (cArr[x+1][y+1] == 'a' || cArr[x+1][y] == 'b' ) { //if the path is blocked by spawnA or spawnB 
        cArr2[x+2][y+2] = 'e'; Arr2[x+2][y+2] = Arr[x][y]; //jumps over it
        cArr2[x][y] = '\0'; Arr2[x][y] = 0;
        //printf("jump over at [%d][%d] \n",x+1,y+1);
    } else if (x == 0 || x == 83 || cArr[x+1][y+1] == 'l' || cArr[x+1][y+1] == 'r' || cArr[x+1][y+1] == 'm') { //if it hits either side of the wall or 'l' or 'r' or 'm'.
        cArr2[x-1][y+1] = 'd'; Arr2[x-1][y+1] = Arr[x][y]; //start moving left & down (move other direction)
        cArr2[x][y] = '\0'; Arr2[x][y] = 0;
        //printf("spawn d at x = %d is shifted to e \n",x);
    } else { //if nothing is blocking the path
        cArr2[x+1][y+1] = cArr[x][y]; Arr2[x+1][y+1] = Arr[x][y]; //move as usual.
        cArr2[x][y] = '\0'; Arr2[x][y] = 0;
        //printf("work pls. \n");
    }    
}
void Spawn::moveSpawnB(int Arr[][Rows], int Arr2[][Rows], char cArr[][Rows], char cArr2[][Rows]){
    //printf("moving spawn B \n");
    for (int x = 0; x < Cols; x++) {
        for (int y = 0; y < Rows; y++) {
            //deleteChar(x, y, Arr2, cArr2);
            if (cArr[x][y] == 'b') { 
                Arr2[x][y+1] = Arr[x][y];
                cArr2[x][y+1] = 'b';
                cArr2[x][y] = '\0';
                Arr2[x][y] = 0;
            }
        }
    }            
}
void Spawn::updateSpawn(int Arr[][Rows], int Arr2[][Rows], char cArr[][Rows], char cArr2[][Rows], N5110 &lcd) {
    for ( int y = 0; y < Rows; y++) {
        for ( int x = 0; x < Cols; x++) {
            deleteChar(x, y, Arr2, cArr2); //cleaning up the array
            if (cArr2[x][y] == 'a' || cArr2[x][y] == 'd' || cArr2[x][y] == 'e') {
                lcd.setPixel(x,y);
                Arr[x][y] = Arr2[x][y]; //to update the main array
                cArr[x][y] = cArr2[x][y];
            } else if (cArr2[x][y] == 'b') {
                lcd.setPixel(x,y); lcd.setPixel(x,y-1);
                Arr[x][y] = Arr2[x][y];  //to update the main array
                cArr[x][y] = 'b';             
            } else if (cArr2[x][y] == 'c') {// l and r (left and right) side of the spawn C for bigger hit box & to deflect spawnDE.
                if (cArr2[x-1][y-1] == '\0'){ //this code to prevent b, d and e from getting replaced 
                    cArr[x-1][y-1] = 'l'; cArr2[x-1][y-1] = 'l';
                } 
                if (cArr2[x+1][y-1] == '\0'){ //this code to prevent b, d and e from getting replaced
                    cArr[x+1][y-1] = 'r'; cArr2[x+1][y-1] = 'r';
                }
                cArr[x][y-1] = 'm'; //to deflect spawnDE.
                cArr[x][y] = cArr2[x][y]; Arr[x][y] = Arr2[x][y]; //to update the main array
                lcd.setPixel(x,y); lcd.setPixel(x,y-1);
                lcd.setPixel(x+1,y-1); lcd.setPixel(x-1,y-1);
            } else {
                Arr[x][y] = 0; cArr[x][y] = '\0';
            }
        }
    }
}
void Spawn::deleteChar(int x, int y, int Arr2[][Rows], char cArr2[][Rows]) { // to clean up the array after killing the spawn.
     if (Arr2[x][y] <= 0) { 
        cArr2[x][y] = '\0';
    //printf("char at Arr2[%d][%d] cleared for good. \n",x,y);
    }  
}          