#ifndef GAMEENGINE_H
#define GAMEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Weapon.h"
#include "Spawn.h"
#include "GUI.h"

#define Rows 48
#define Cols 84

struct Array {
    //int array to store the spawn health
    int Arr[Cols][Rows];
    //char array to differentiate the 4 different kind of spawn A, B, C and D&E.
    char cArr[Cols][Rows];  
};

/** GameEngine Class
@brief Main library for the game
@author JianWei Lee
@date April 2017
*/
class GameEngine
{
    
public:
    GameEngine();
    ~GameEngine();
    
    /**Initialise GameEngine
    *
    *@brief Set the number of life at every level to 3 \n
    *@brief To initialise all the variables of Weapons and Spawns \n
    *@param w - the current number level
    */
    void init(int w);
    
    /**Update game
    *
    *@brief This is where all the gameplay and drawing is gathered \n
    *@brief The only way to lose this game is when the spawns reaches the player side (y = 46) for 3 times in a wave\n
    *@brief Lights up LEDs according to number of lifes left
    */
    void update(Gamepad &pad, N5110 &lcd);
    
    /**Weapon Upgrades
    *
    *@brief Weapon upgrade will happen everytime after completing a game wave\n
    *@brief This function connects class GUI and Weapons to display weapon levels and confirm upgrades
    */
    void weapUpgrade(Gamepad &pad, N5110 &lcd);
    
    /**Starting Menu
    *
    *@brief Few strings to be printed on the lcd before starting the game\n
    *@brief Light up LEDs in a knight rider pattern
    */
    void startingMenu(Gamepad &pad, N5110 &lcd);
    
    /**Update Retry array using Main array
    *
    *@brief To make a copy of the Main array to Retry array
    */
    void update_MainToRetry();
    
    /**Update Main array using Retry array
    *
    *@brief To make a copy of the Retry array to Main array
    */
    void update_RetryToMain();
    
    /**Reset the game
    *
    *@brief Only thing that resets is the array and weapon's variables
    */
    void reset_Game();
    
    int doneUpgrade_flag;
    int retry_flag;
    int gameMenu_flag;
    
    //Main and secondary array required to allow the spawn move and to take damage
    Array main;
    Array scnd;
    //Retry array - when player press retry, this array will be used
    Array retry;
    
    
private:
    //declare class with their name 
    Weapon weap;
    Weapon _d1;
    Weapon _d2;
    Spawn spa;
    GUI _gui;
    
    int drawit;
    int ledNumber;
    int NumberOfLife;
    int fireInTheHole_flag;
    
    //Turn on LEDs
    //Number of LEDs that light up will depends on number of lifes left
    void numberOfLife_leds(Gamepad &pad);
    
    //Draw spawn
    //This is where summon spawn, moving spawn and update array happens.
    void drawSpawn(N5110 &lcd);
    
    //Laser and cannon
    //This function puts laser and cannon together because cannon can only fire when laser is switched on
    void laser_and_cannon(Gamepad &pad, N5110 &lcd);
    
    //Game Rule
    //The only way to lose this game is when the spawns reaches the player side (y = 46) for 3 times in a wave
    void checkGameRule(Gamepad &pad, N5110 &lcd);
    
    //Bomb and Shield
    //This function puts bomb and shield together to prevent double click 
    void bomb_And_Shield(Gamepad &pad, N5110 &lcd);
    
    //Update array
    //After a loop in the game, the main array will be updated using the secondary array
    void updateArray();
    
    /**Game over
    *
    *This function will be executed when player loses
    *Allows player to retry the wave or give up.
    */    
    void gameOver(Gamepad &pad, N5110 &lcd);
    
    
};

#endif