#include "GUI.h"


GUI::GUI()
{

}

GUI::~GUI()
{

}
void GUI::startingMenu(N5110 &lcd) {
    lcd.printString("Meteor defense",0,0);
    lcd.printString("Press start",10,2);
    lcd.printString("to play",10,3);
    lcd.printString("by Lee.",48,5);
}
void GUI::upgrades(int a, int b, int c, int d, int e, int f, int g, int h, int i, int j, int k, Gamepad &pad, N5110 &lcd) {
    printf("test struct passing %d %d %d %d %d %d %d %d \n",a,b,c,d,e,f,g,h);
    Cursors _cursor = cursor(pad);
    if (pointsGiven == 0){ //if upgrade points are not yet given
        pointsUpgrade += 2; //give the points
        pointsGiven = 1;
    }
    if (upgrading1_flag == 0) { //main upgrades page
        main_UpgradesPage(lcd);
        cursor_y = _cursor.number_y;
        drawCursor(cursor_y, lcd);
        printf("cursor_y = %d \n",cursor_y);
    } else { //weapon picked
        cursor_y1 = _cursor.number_y;
        drawCursor(cursor_y1, lcd);
        //picking weapon's variables
        if (cursor_y == 0){
            //printf("laser selected \n");
            laser_UpgradesPage(a, lcd);
        } else if (cursor_y == 1){
            //printf("bomb selected \n");
            bomb_UpgradesPage(b, c, d, lcd);
            cursor_y = 1;
        } else if (cursor_y == 2){
            //printf("drone selected \n");
            drone_UpgradesPage(e, f, lcd);
        } else if (cursor_y == 3){
            //printf("shield selected \n");
            shield_UpgradesPage(g, h, lcd);
        } else if (cursor_y == 4) {
            cannon_UpgradesPage(i, j, k, lcd);
            cursor_y = 4;
        }
        if (pad.check_event(Gamepad::BACK_PRESSED)) { //if back button is pressed
            upgrading1_flag = 0; //back to the main_upgrades.
            cc = 0;  // reset the cursor
        }
        upgradesData(pad);
    }
    pad_events(pad);
}
void GUI::pad_events(Gamepad &pad) {
    if (pad.check_event(Gamepad::A_PRESSED)) { //if A button is pressed
        upgrading1_flag = 1; //go into the weapons picked.
        cc = 0; //reset the cursor
        pad.tone(750.0,0.1);
        preventDoubleClick(pad);
    }  
    if (pointsUpgrade == 0) { // when no more points available
        if (pad.check_event(Gamepad::START_PRESSED)) { //pressing start will complete the upgrades
            pointsGiven = 0;
            saveTheData_flag = 1; 
            preventDoubleClick(pad);
        }
    }   
}
void GUI::upgradesData(Gamepad &pad) {
    //printf("p = %d \n",pointsUpgrade);
        if (pointsUpgrade == 2) { //if there are 2 points remaining
            if (pad.check_event(Gamepad::A_PRESSED)) { //if A button is pressed inside the weapons picked.
                pointsUpgrade -= 1; // minus an upgrade point
                upgradePicked = cursor_y; //saving upgrades data
                upgradePicked1 = cursor_y1;
                pad.tone(750.0,0.1);
                preventDoubleClick(pad);
                //printf("p = %d, upgradePicked = %d, upgradePicked1 = %d \n",pointsUpgrade,upgradePicked,upgradePicked1);
            }
        } else if (pointsUpgrade == 1) {
            if (pad.check_event(Gamepad::A_PRESSED)) { //if A button is pressed inside the weapons picked.
                pointsUpgrade -= 1; // minus an upgrade point
                upgrade1Picked = cursor_y; //saving upgrades data
                upgrade1Picked1 = cursor_y1;
                pad.tone(750.0,0.1);
                preventDoubleClick(pad);
                //printf("p = %d, upgrade1Picked = %d, upgrade1Picked1 = %d \n",pointsUpgrade,upgrade1Picked,upgrade1Picked1);
            }
        } else if (pointsUpgrade == 0) {//if no more points left, bring the player back to main upgrade page
            upgrading1_flag = 0; 
        }
}
void GUI::main_UpgradesPage(N5110 &lcd) { 
    options = 4; // 0, 1, 2, 3 
    sprintf(pointsRemaining, "Points : %d",pointsUpgrade);
    lcd.printString(pointsRemaining,1,0);
    lcd.printString("Laser",10,1); //option 0
    lcd.printString("Bomb",10,2);  //option 1
    lcd.printString("Drone",10,3); //option 2
    lcd.printString("Shield",10,4); //option 3
    lcd.printString("Cannon",10,5); //option 4
    if (pointsUpgrade == 0) { //if no more points left.
        lcd.printString("Done",57,5); 
    }
}
void GUI::laser_UpgradesPage(int laserDamage, N5110 &lcd) {
    options = 0;
    sprintf(upgrade1, "Damage %d", laserDamage);
    lcd.printString("Laser",1,0);
    lcd.printString(upgrade1,10,1);
}
void GUI::bomb_UpgradesPage(int bombDamage, int bombR, int bombCooldown, N5110 &lcd) {
    options = 2;
    sprintf(upgrade1, "Damage %d", bombDamage);
    sprintf(upgrade2, "Radius %d", bombR);
    sprintf(upgrade3, "Cooldown %d", bombCooldown);
    lcd.printString("Bomb",1,0);
    lcd.printString(upgrade1,10,1);
    lcd.printString(upgrade2,10,2);
    lcd.printString(upgrade3,10,3);
}
void GUI::drone_UpgradesPage(int droneDamage, int droneRange, N5110 &lcd) {
    options = 1;
    sprintf(upgrade1, "Damage %d", droneDamage);
    sprintf(upgrade2, "Atk Range %d", droneRange);
    lcd.printString("Drone",1,0);
    lcd.printString(upgrade1,10,1);
    lcd.printString(upgrade2,10,2);
}
void GUI::shield_UpgradesPage(int shieldCapacity, int shieldRegenRate, N5110 &lcd) {
    options = 1;
    sprintf(upgrade1, "Cpcty %d", shieldCapacity);
    sprintf(upgrade2, "RegenRate %d", shieldRegenRate);
    lcd.printString("Shield",1,0);
    lcd.printString(upgrade1,10,1);
    lcd.printString(upgrade2,10,2);
}
void GUI::cannon_UpgradesPage(int cannonDamage, int cannonCapacity, int cannonRegenRate, N5110 &lcd) {
    options = 2;
    sprintf(upgrade1, "Damage %d", cannonDamage);
    sprintf(upgrade2, "Cpcty %d", cannonCapacity);
    sprintf(upgrade3, "RegenRate %d", cannonRegenRate);
    lcd.printString("Cannon",1,0);
    lcd.printString(upgrade1,10,1);
    lcd.printString(upgrade2,10,2);
    lcd.printString(upgrade3,10,3);
}
Data GUI::get_data() {
    Data sd = {upgradePicked,
               upgradePicked1,
               upgrade1Picked,
               upgrade1Picked1,    
                };
    return sd;
}
Cursors GUI::cursor(Gamepad &pad) {
    Vector2D coordinate = pad.get_coord();
    float y = coordinate.y;
    //printf(" y = %f \n",y);
    if (y < -0.8f) {
        printf("going down \n");
        if (cc < options) {
            cc += 1;
            //printf("cc = %d \n",cc);
            while (1) { 
                //printf("release joystick pls.");
                //printf("cc = %d \n",cc);
                wait(0.1);
                Vector2D coordinate = pad.get_coord();
                float y = coordinate.y;
                if (y > -0.1f) {
                    break; // when joystick released. break out of this while loop.
                }
            }
        }
    }
    if (y > 0.8f) {
        printf("going up \n");
        if (cc > 0) {
            cc -= 1;
            //("cc = %d /n",cc);
            while (1) {
                //printf("release joystick pls. ");
                //printf("cc = %d /n",cc);
                wait(0.1);
                Vector2D coordinate = pad.get_coord();
                float y = coordinate.y;
                if (y < 0.1f) {
                    break; //when joystick released. break out of this while loop.    
                } 
            }
        }
    }
    Cursors _cursor = {cc};
    return _cursor;
}
void GUI::drawCursor(int Cy, N5110 &lcd){ //simple square cursor
    lcd.setPixel(4,11 + Cy * 8);
    lcd.setPixel(5,11 + Cy * 8);
    lcd.setPixel(4,12 + Cy * 8);
    lcd.setPixel(5,12 + Cy * 8);
}
void GUI::preventDoubleClick(Gamepad &pad) { //use this to prevent unintended double clicking that always happens with the gamepad
    wait(0.1);                               //yes, the gamepad is that bad.
    if (pad.check_event(Gamepad::A_PRESSED)) {
        printf("A double click prevented!!! \n"); 
    }
    if (pad.check_event(Gamepad::START_PRESSED)) {
        printf("START double click prevented!!! \n"); 
    }
    if (pad.check_event(Gamepad::BACK_PRESSED)) {
        printf("BACK double click prevented!!! \n"); 
    }
}