#include "mbed.h"
#include "N5110.h"

/**
@ snake maximum body columns value can be used
*/
int snakeColumns[84];

/**
@ snake maximum body columns value can be used
*/
int snakeRows[48];

/**
@ all pixels were seted
@ param.84 - x value to add
@ param.48 - y value to add
*/
char cells[84][48];//all pix

/**
@ define the structure of snake
@ param.x - initial x value of snake to add
@ param.y - initial y value of snake to add
@ param.headx - x-coordinate of snake head to add
@ param.heady - y-coordinate of snake head to add
*/
typedef struct Snake Snake;//structure of snake
struct Snake {//structure of snake
    int x;//initial x value of snake
    int y;//initial y value of snake
    int headx;//x-coordinate of snake head
    int heady;//y-coordinate of snake tail
};

/**
@define the name of snake
*/
Snake snake;//name of Snake


int Food_x=20;//initial x value of Food
int Food_y=20;//initial y value of Food

/**
@define the direction of snake's movement
*/
int up;
int down;
int left;
int right;

/**
@initialize the value of LED when LED is not lighted
*/
int LED = 0;


/**
@initialize the value of score
*/
const char score=0;

/**
@ initialize the value of snake length and snake's life and the food appears
@param.snakeLength - snake length to add
@param.snakelife - snake is alive to add
@param.foodyes - food appears to add
*/
int snakeLength = 6;
int snakelife = 1;
int foodyes = 1;
// change this to alter tolerance of joystick direction
#define DIRECTION_TOLERANCE 0.05

/**
@ connections for joystick
*/
AnalogIn xPot(p15);
AnalogIn yPot(p16);
DigitalIn button(p17);
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);

/**
@ timer to regularly read the joystick
*/
Ticker pollJoystick;
/**
@ Serial for debug
*/
Serial serial(USBTX,USBRX);

/**
@ create enumerated type (0,1,2,3 etc. for direction)
@ could be extended for diagonals etc.
*/
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
}

/**
@define the struct for Joystick
@ param.x - current x value to add
@ param.y - current y value to add
@ param.x0 - centred x value to add
@ param.y0 - centred y value to add
@ copied from sample code, but do not know why they have error
*/
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};
/**
@ create struct variable
*/
Joystick joystick;

int printFlag = 0;

/**
@ function prototypes
*/
void calibrateJoystick();
void updateJoystick();
void light();
void wholeSnake();
void drawSnake();
void drawFood();
void moveSnake();
void eatFood();
void crashCheck();
void endGame();

/**
@ main code
@ calibrateJoystick() - get centred value of joystick
@ read joystick 10 times per second
@control the joysick
*/
int main()
{
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second

    while(1) {

        if (printFlag) {  // if flag set, clear flag and print joystick values to serial port
            printFlag = 0;
            serial.printf("x = %f y = %f button = %d ",joystick.x,joystick.y,joystick.button);

            // check joystick direction
            if (joystick.direction == UP)
                serial.printf(" UP\n");
            if (joystick.direction == DOWN)
                serial.printf(" DOWN\n");
            if (joystick.direction == LEFT)
                serial.printf(" LEFT\n");
            if (joystick.direction == RIGHT)
                serial.printf(" RIGHT\n");
            if (joystick.direction == CENTRE)
                serial.printf(" CENTRE\n");
            if (joystick.direction == UNKNOWN)
                serial.printf(" Unsupported direction\n");

        }

        if (button ==0) { //button state assume pull-down used, 0 = unpressed
            lcd. printString ("Game Start", 2,2);// print cover
            lcd. printString ("By Troy",3,3);//print cover
        } else {
            lcd.clear();//function of clear screen
            light();//function to light the led
            drawSnake();//draw a snake
            drawFood();//draw food
            moveSnake();
            eatFood();//function of checking the snake eat food
            crashCheck();//check the collision detection
            endGame();
            wait(0.2);//wait 0.2 second repeat the whine loop

        }
    }
}
/**
@ read default positions of the joystick to calibrate later readings
@ initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
@ param.joystick.x0, value of x0 is to add
@ param.joystick.y0, value of y0 is to add
*/
void calibrateJoystick()
{
    button.mode(PullDown);
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}

/**
@ read value from joystick
*/
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.button = button;


    /**
    @ calculate direction depending on x,y values
    @ tolerance allows a little lee-way in case joystick not exactly in the stated direction
    */
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;

    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
        snake.y = snake.y-1;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
        snake.y = snake.y+1;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
        snake.x = snake.x+1;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
        snake.x = snake.x-1;
    } else {
        joystick.direction = UNKNOWN;
    }
    /**
    @ set flag for printing
    */
    printFlag = 1;

    lcd.init();//initialize nokia N5110
    lcd.setBrightness(0.5); // put backlight on 50%
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second
    lcd.refresh();//reset the screen
}
/**
define the light function
*/
void light()
{
    if (button == 1)
        LED = 1;
    else
        LED = 0;
}

/**
define the wholeSnake function
*/
void wholeSnake()
{

    snake.x = 5;
    snake.y = 5;
    snake.headx = 11;
    snake.heady = 7;

}


/**
define the eatFood function
*/
void eatFood()
{
    while (1) {

        if(foodyes == 1) {
            srand(time(NULL));
            int Food_x = rand() % 84;
            int Food_y= rand() % 48;
            while(Food_x%84 != 0)
                Food_x++;
            while(Food_y%48 != 0)
                Food_y++;
        }

    }

    /**
    define the darwSnake function
    */
    void drawSnake() {

        lcd.drawRect(snake.x,snake.y,6,2,1);//draw the rectangle with top left position, height, width and fill the rectangle in black
    
    }

    /**
    define the drawFood function
    */
    void drawFood() { //method to define drawFood function
        
        lcd.drawRect(Food_x,Food_y,2,2,1);//draw the rectangle with top left position, height, width and fill the rectangle in black
        
    }

    /**
    define the moveSnake function
    */
    void moveSnake() { //method to define moveSnake function
        button == 1;// button of joystick is pressed

        switch (direction) {//check the direction of the joystick button is pressed
            case up:  //when the direction of joystick is up
                snake.y = snake.y-1;//the change of y value fron joystick
                break;
                jump out

            case down;
                snake.y = snake.y+1;
                break;

            case left;
                snake.x = snake.x+1;
                break;

            case right;
                snake.x = snake.x+1;
                break;
        }
    }

    /**
    define the crashCheck function
    */
    void crashCheck() { //method to define endGame function
        while(1) { //infinite loop

            // if snake hit itself
            if (snake.headx == snake.x && snake.heady == snake.y) {//coordinate of snake head is equal to snake tail
                snakelife = 0;// snake dead
                endGame();//game end
            }


            //if snake hit wall
            if (snake.x > 47 || snake.x < 0  || snake.y < 0 || snake.y > 83) {//the limit of top and bottom side
                //the limit of left and right side
                //check the snake head over the value of four sides
                snakelife = 0;// snake dead
                endGame();//game end

            }
        }
    }

    /**
    define the endGame function
    */
    void endGame () { //method to define endGame function

        lcd.printString ("END!", 29, 0);//the position and word"End" are printed on LCD display
        lcd.printString ("Score: ", 10, 2);//the position and word"Score" are printed on LCD display
        lcd.printString (score, 20, 2);//the position and number are printedon LCD display
        wait (0.2);
}
