/*-----------------------------------------------------
 File Name : main.cpp
 Purpose : For esp8266 mbed porting
 Creation Date : 22-06-2017
 Last Modified :
 Created By : Jeasine Ma [jeasinema[at]gmail[dot]com]
-----------------------------------------------------*/
#include <cstdarg>
#include <cstring>
#include "mbed.h"
#include "esp8266.h"

Serial ser2usb(PA_2, PA_3, 115200);
//DigitalOut LED(PD_2);
//DigitalIn humansensor(PA_0); 
PwmOut mypwm19(PB_4);
PwmOut mypwm20(PB_5);
PwmOut mypwm21(PB_13);
PwmOut mypwm22(PB_3);
//DigitalIn mybutton(PA_12);
DigitalOut myled(PB_14);

int test_main(void){
    Serial esp8266(PA_9, PA_10, 9600);
    while(1){
        if(ser2usb.readable())
            esp8266.putc(ser2usb.getc());
        if(esp8266.readable())
            ser2usb.putc(esp8266.getc());
    }
}

int main(void) {
      myled = 0;

    // 选定与 esp8266 相连接的串口，WiFi 名称和密码
    // 参数分别为 TX pin / RX pin / SSID / Password
    ser2usb.printf("Reset.\r\n");
    Esp8266 client(PA_9, PA_10, "TSINGHUA.iCenter", "TS.icenter");

    //声明所有的传感器，每行一个，每个由名字、单位两部分组成，最后一行必须为空指针作为结尾
    //服务器收到声明后，将在网页上显示这些传感器
    const char* sensors[][2] = {
        //"pressure", "Pa",
//        "temperature", "C",
//        "humidity", "%",
        "huamn","person",
        NULL, NULL //最后一行以空指针作为结束标记
    };

    //声明所有的执行器，每行一个，每个由名字、参数类型两部分组成，最后一行必须为空指针作为结尾
    //服务器收到声明后，将在网页上显示这些执行器
    const char* actuators[][2] = {
        "servo19", "int",
        "servo20", "int",
        "servo21", "int",
        "servo22", "int",
        "LED01", "int",
        //"switch2", "int",
        NULL, NULL //最后一行以空指针作为结束标记
    };

    //连接到服务器
    client.connect_mqtt_broker("tdxls-iot.xicp.net", sensors, actuators);

    ser2usb.printf("Initialization done.\r\n");

    char actuator_name[32], control_value[32];
    float last_report=0;
    Timer t;// 定时器用于计量发送传感器数据的时间
    t.start();

    while(1) {
        //检查有没有收到新的执行器控制指令
        if(client.get_control_cmd(actuator_name, control_value)){
            ser2usb.printf("Received CMD %s, %s\r\n", actuator_name, control_value);
            //判断哪个执行器收到命令
            if (!strcmp(actuator_name, "servo19")){
                //LED = atoi(control_value);
                if (!strcmp(control_value, "1")){
                    mypwm19.pulsewidth(0.001);
                }else{
                    mypwm19.pulsewidth(0.002);
                }
                    
            }else if (!strcmp(actuator_name, "servo20")){
                if (!strcmp(control_value, "1")){
                    mypwm20.pulsewidth(0.001);
                }else{
                    mypwm20.pulsewidth(0.002);
                }
            }else if (!strcmp(actuator_name, "servo21")){
                if (!strcmp(control_value, "1")){
                    mypwm21.pulsewidth(0.001);
                }else{
                    mypwm21.pulsewidth(0.002);
                }
                    
            }else if (!strcmp(actuator_name, "servo22")){
                if (!strcmp(control_value, "1")){
                    mypwm22.pulsewidth(0.001);
                }else{
                    mypwm22.pulsewidth(0.002);
                }
                //do something for switch2
            }else if (!strcmp(actuator_name, "LED01")){
                if (!strcmp(control_value, "1")){
                    myled = 1;
                }else{
                    myled = 0;
                }
            }
        }else{
            //ser2usb.printf("Not Received CMD\r\n");

        }

        /*if(t.read() - last_report > 1){ // 每1s发送汇报一次传感器数据

            //汇报传感器数据，两个参数分别是传感器名字和值
            //client.publish_value("pressure", "100000 Pa");
//            client.publish_value("temperature", "20 C");
//            client.publish_value("humidity", "30 %");
            client.publish_value("huamn", "30 %");
            
            last_report = t.read();
        }*/
    }
}
