#include "mbed.h"
#include "motordriver.h"
#include "ultrasonic.h"
#include "SongPlayer.h"
int x=1;


void dist(int distance)
{
    if (distance<100){
        x=0;
        }
    //put code here to execute when the distance has changed
    printf("Distance %d mm\r\n", distance);

}


ultrasonic mu(p9, p10, .1, 1, &dist);  
//BusOut myled(LED1,LED2,LED3,LED4);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial blue(p28,p27);
AnalogIn ain(A0); //p15
SongPlayer mySpeaker(p26);
Motor A(p23, p6, p5, 1); // pwm, fwd, rev, can brake 
Motor B(p21, p7, p8, 1); // pwm, fwd, rev, can brake

float note[18]= {1568.0,1396.9,1244.5,1244.5,1396.9,1568.0,1568.0,1568.0,1396.9,
                 1244.5,1396.9,1568.0,1396.9,1244.5,1174.7,1244.5,1244.5, 0.0
                };
float duration[18]= {0.48,0.24,0.72,0.48,0.24,0.48,0.24,0.24,0.24,
                     0.24,0.24,0.24,0.24,0.48,0.24,0.48,0.48, 0.0
                    };

int main()
{

    mu.startUpdates();//start measuring the distance
    char bnum=0;
    char bhit=0;
    
    while(x==1){
        mu.checkDistance(); 
        
        led1 = (ain > 0.15f) ? 1 : 0;
        led2 = (ain > 0.30f) ? 1 : 0;
        led3 = (ain > 0.45f) ? 1 : 0;
        led4 = (ain > 0.7f) ? 1 : 0;
        A.speed(0.4); 
        B.speed(0.4);

        
        

       // printf("Distance %d mm\r\n", distance);
        
    }
        mySpeaker.PlaySong(note,duration);
    // loops forever while song continues to play to end using interrupts
        A.speed(0); 
        B.speed(0);
    while(1){
            if (blue.getc()=='!') {
                if (blue.getc()=='B') { //button data packet
                    bnum = blue.getc(); //button number
                    bhit = blue.getc(); //1=hit, 0=release
                    if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                       // myled = bnum - '0'; //current button number will appear on LEDs
                        switch (bnum) {
                            case '1': //number button 1
                                if (bhit=='1') {
                                    A.speed(0); 
                                    B.speed(0);
                                } else {
                                    //add release code here
                                }
                                break;
                            case '2': //number button 2
                                if (bhit=='1') {
                                    //add hit code here
                                } else {
                                    //add release code here
                                }
                                break;
                            case '3': //number button 3
                                if (bhit=='1') {
                                    //add hit code here
                                } else {
                                    //add release code here
                                }
                                break;
                            case '4': //number button 4
                                if (bhit=='1') {
                                    //add hit code here
                                } else {
                                    //add release code here
                                }
                                break;
                            case '5': //button 5 up arrow
                                if (bhit=='1') {
                                    A.speed(1); 
                                    B.speed(1);
                                    wait(0.02);
                                } else {
                                    //add release code here
                                }
                                break;
                            case '6': //button 6 down arrow
                                if (bhit=='1') {
                                    A.speed(-1); 
                                    B.speed(-1);
                                    wait(0.02);
                                } else {
                                    //add release code here
                                }
                                break;
                            case '7': //button 7 left arrow
                                if (bhit=='1') {
                                    A.speed(-1); 
                                    B.speed(1);
                                    wait(0.02);
                                } else {
                                    //add release code here
                                }
                                break;
                            case '8': //button 8 right arrow
                                if (bhit=='1') {
                                    A.speed(1); 
                                    B.speed(-1);
                                    wait(0.02);
                                } else {
                                    //add release code here
                                }
                                break;
                            default:
                                A.speed(0.3); 
                                B.speed(0.3);
                                break;
                        }
                    }
                }
           }
     }
}