/* Created on 4/21/2017
*  By Varun Malhotra
*/

#include "mbed.h"
#include "rtos.h"
 
RawSerial pc(USBTX, USBRX); // tx, rx
RawSerial device(p9, p10);  // tx, rx
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

// character to interlock the the trasnmitter and receiver
volatile char c = 0xAA;
volatile int cmnd_received = 0;

void serial_conn_receiver(void)
{
         while(1) {   
            
            if (pc.readable()) {
                c = pc.getc();
                
                if (c == 'U') {
                    
                    c = 0x55;
                    cmnd_received = 1;
                    myled1 = 1;
                    myled2 = 0;
                    myled3 = 0;
                    myled4 = 0;
                     
                } else if (c == 'D') {
                    
                    c = 0x56;
                    cmnd_received = 1;
                    myled1 = 0;
                    myled2 = 1;
                    myled3 = 0;
                    myled4 = 0;
                
                } else if (c == 'L') {
                    
                    c = 0x57;
                    cmnd_received = 1;
                    myled1 = 0;
                    myled2 = 0;
                    myled3 = 1;
                    myled4 = 0;
                
                } else if (c == 'R') {
                    
                    c = 0x58;
                    cmnd_received = 1;
                    myled1 = 0;
                    myled2 = 0;
                    myled3 = 0;
                    myled4 = 1;
                
                
                } else if (c == 'S') {
                    
                    c = 0x59;
                    cmnd_received = 1;
                    myled1 = 0;
                    myled2 = 0;
                    myled3 = 0;
                    myled4 = 0;
                
                } else if (c == 'M') {
                    
                    c = 0x60;
                    cmnd_received = 1;
                    myled1 = 0;
                    myled2 = 0;
                    myled3 = 0;
                    myled4 = 0;   
                }
            }

            Thread::wait(1000);
        }
}
 


int main() {
    
    device.baud(600);
    
    //spawn thread to retrieve characters from the GUI
    Thread t1(serial_conn_receiver);
    
    while (1) {
                
            if (cmnd_received) { 
                
                device.putc(c);
                cmnd_received = 0;
            
            } else {
                device.putc(0xAA);    
            }
            
            Thread::wait(20);

       }

}