#include "mbed.h"
#include <rtos.h>
// new class to play a note on Speaker based on PwmOut class
class SongPlayer {
public:
    SongPlayer(PinName pin) : _pin(pin) {
    // _pin(pin) means pass pin to the constructor
    }
    
    // class method to play a note based on PwmOut class
    void PlaySong(float frequency[], float duration[], float volume = 1.0) {
        notecount = 0;
        while (duration[notecount] != 0.0) {
            _pin.period(1.0 / frequency[notecount]);
            _pin = volume / 2.0;
            Thread::wait((int) (duration[notecount++] * 1000));
        }
        _pin = 0.0;
    }
    
private:
    PwmOut _pin;
    int notecount;
    float vol;
    float * frequencyptr;
    float * durationptr;
};