#include "mbed.h"
#include "math.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "SongPlayer.h"
#include "motordriver.h"

#define PI 3.14159

//Serial Debug
Serial rfLink(p9, p10);
Serial pc(USBTX, USBRX);


//Threads
Thread audioThread, motorThread, thread3, gameDisplayThread;

//Mutexes
Mutex commMutex;

//Motors
Motor left(p22, p16, p15, 1); // pwm, fwd, rev, can brake
Motor right(p21, p17, p18, 1); // pwm, fwd, rev, can brake

//Command Byte
char commByte = 0;

DigitalOut ledup(p20);
DigitalOut leddown(p19);
DigitalOut ledleft(p18);
DigitalOut ledright(p17);

//Music & Sounds
float note[18]= {1568.0,1396.9,1244.5,1244.5,1396.9,1568.0,1568.0,1568.0,1396.9,
                 1244.5,1396.9,1568.0,1396.9,1244.5,1174.7,1244.5,1244.5, 0.0
                };
float duration[18]= {0.48,0.24,0.72,0.48,0.24,0.48,0.24,0.24,0.24,
                     0.24,0.24,0.24,0.24,0.48,0.24,0.48,0.48, 0.0
                    };
                    
float note2[] = {
    2637.0, 2637.0, 0, 2637.0,
    0, 2093.0, 2637.0, 0,
    3136.0, 0, 0,  0,
    1568.0, 0, 0, 0,
    
    2093.0, 0, 0, 1568.0,
    0, 0, 1319.0, 0,
    0, 1760.0, 0, 1976.0,
    0, 1865.0, 1760.0, 0,
     
    1568.0, 2637.0, 3136.0,
    3520.0, 0, 2794.0, 3136.0,
    0, 2637.0, 0, 2093.0,
    2349.0, 1976.0, 0, 0,
     
    2093.0, 0, 0, 1568.0,
    0, 0, 1319.0, 0,
    0, 1760.0, 0, 1976.0,
    0, 1865.0, 1760.0, 0,
     
    1568.0, 2637.0, 3136.0,
    3520.0, 0, 2794.0, 3136.0,
    0, 2637.0, 0, 2093.0,
    2349.0, 1976.0, 0, 0
};

float duration2[] = {
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
 
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
 
  0.1111, 0.1111, 0.1111,
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
 
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
 
  0.1111, 0.1111, 0.1111,
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833,
  0.0833, 0.0833, 0.0833, 0.0833, 0.0
};

float note3[] = {440.0, 440.0, 440.0, 349.0, 523.0, 440.0, 349.0, 523.0, 440.0, 
                 0.0, 659.0, 659.0, 659.0, 698.0, 523.0, 415.0, 349.0, 523.0, 
                 440.0, 0.0};

float duration3[] = {0.5, 0.5, 0.5, 0.35, 0.15, 0.5, 0.35, 0.15, 0.65, 0.5,
                     0.5, 0.5, 0.5, 0.35, 0.15, 0.5, 0.35, 0.15, 0.65, 0.5,
                     0.0}; 
SongPlayer mySpeaker(p26);

void playSound() {
    //Setup PWM hardware for a Class D style audio output
    int songSelect = 0;
    while (true) {
        commMutex.lock();
        if (commByte == 0x60) {
            commMutex.unlock();
            songSelect++; 
            if (songSelect % 3 == 0)
                mySpeaker.PlaySong(note2,duration2);
            else if (songSelect % 3 == 1)
                mySpeaker.PlaySong(note3,duration3);
            else
                mySpeaker.PlaySong(note,duration);
        } else {
            commMutex.unlock();
            Thread::yield();
        }
    }
}

void runMotors(float l, float r, int wait_time) {
        left.speed(l);
        right.speed(r);
        Thread::wait(wait_time);
        left.stop(1);
        right.stop(1);
        Thread::wait(100);    
}

void moveRobot() {
    while (true) {
        commMutex.lock();
        if (commByte == 0x55) {
            commMutex.unlock();
            runMotors(0.75, 0.75, 2000);
            //pc.printf("Forward\n\r");
            ledup = 1;
        } else if (commByte == 0x56) {
            commMutex.unlock();
            runMotors(-0.75, -0.75, 2000);
            //pc.printf("Backward\n\r");
            leddown = 1;
        } else if (commByte == 0x57) {
            commMutex.unlock();
            runMotors(-0.75, 0.75, 500);
            //pc.printf("Left\n\r");
            ledleft = 1;
        } else if (commByte == 0x58) {
            commMutex.unlock();
            runMotors(0.75, -0.75, 500);
            //pc.printf("Right\n\r");
            ledright = 1;
        } else if (commByte == 0x59) {
            commMutex.unlock();
            runMotors(1.0, -1.0, 1000);
            runMotors(-1.0, 1.0, 1000);
        } else {
            commMutex.unlock();
            //pc.printf("Stop\n\r");
        }
        ledup = 0;
        leddown = 0;
        ledleft = 0;
        ledright = 0;
    }
}

int main() {
    rfLink.baud(600);
    pc.printf("Started\n");
    motorThread.start(moveRobot);
    audioThread.start(playSound);
    while (true) {         
        //RF Receive Code
        if (rfLink.readable()) {
            commMutex.lock();
            commByte = rfLink.getc();
            commMutex.unlock();
        } else {
            Thread::wait(10);
        }
    }
}