#include "mbed.h"
#include "rtos.h"
#include "C12832_lcd.h"

//FINITE STATE MACHINE EVENTS
#define NO_EVENT 0
#define TIME_OUT 1
#define BUTTON_PRESS 2

//STATES
#define STATE_0 0
#define STATE_1 1
#define STATE_2 2
#define STATE_3 3
#define STATE_4 4
#define STATE_5 5



//pass event via message queue
typedef struct {
    int    event;   /* AD result of measured voltage */
} message_t;

MemoryPool<message_t, 16> mpool;
Queue<message_t, 16> queue;

//button plus local display
DigitalIn fire(p14);
C12832_LCD lcd; //On board LCD display

//leds for debug
DigitalOut led(LED1); //button press
DigitalOut led2(LED2); //fsm thread
DigitalOut led3(LED3);
DigitalOut led4(LED4); //timeout thread


    
void timeout_event(void const *n) 
{
        //generate local display info
        lcd.cls();
        lcd.locate(40,5);
        lcd.printf("timeout event");
        
       
        //event via a message queue
        message_t *message = mpool.alloc();
        message->event = TIME_OUT; 
        queue.put(message);
        
        led4 =  !led4;
        
}


void button_event_thread(void const *argument) {
    while (true) {
     
        //debouce delay for switch
        Thread::wait(250);
        
        if (fire) 
            {
         
            lcd.cls();    
            lcd.locate(0,1);
            lcd.printf("button event");    
                
           
            //event via a message queue
            message_t *message = mpool.alloc();
            message->event = BUTTON_PRESS; 
            queue.put(message);
            
            led = !led;
            }
    }
}

        
int main (void) {
    
//Thread fsm(fsm_thread); 
Thread button_event(button_event_thread);
RtosTimer timer(timeout_event, osTimerPeriodic, (void *)0);

int state = STATE_0;

 
    //start timer with a 2 sec timeout 
    timer.start(2000); 
    
    while (true) {
        switch(state)
            {
            case STATE_0:
                lcd.cls();
                lcd.locate(0,2);
                lcd.printf("FSM START");
                
                osEvent evt = queue.get();
                if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                
                       
                    if(message->event == BUTTON_PRESS) state = STATE_1;
                    if(message->event == TIME_OUT) state = STATE_0;
                
                    mpool.free(message);
                    }
                
                timer.start(2000);
            
            break;
            
            case STATE_1:
                lcd.cls();
                lcd.locate(0,2);
                lcd.printf("FSM COUNTER  1"); 
                
                evt = queue.get();
                if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                
                       
                    if(message->event == BUTTON_PRESS) state = STATE_2;
                    if(message->event == TIME_OUT) state = STATE_0;
                
                    mpool.free(message);
                    }
                 
             
                timer.start(2000);
            
            break;
            
            case STATE_2:
                lcd.cls();
                lcd.locate(0,2);
                lcd.printf("FSM COUNTER  2"); 

               evt = queue.get();
               if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                
                       
                    if(message->event == BUTTON_PRESS) state = STATE_3;
                    if(message->event == TIME_OUT) state = STATE_1;
                
                    mpool.free(message);
                    }

                timer.start(2000);
            
            break;          
            
            case STATE_3:
                lcd.cls();
                lcd.locate(0,2);
                lcd.printf("FSM COUNTER  3"); 
                
                evt = queue.get();
               if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                
                       
                    if(message->event == BUTTON_PRESS) state = STATE_4;
                    if(message->event == TIME_OUT) state = STATE_2;
                
                    mpool.free(message);
                    }
                 
               
                timer.start(2000);
            
            break;    
            
            case STATE_4:
                lcd.cls();
                lcd.locate(0,2);
                lcd.printf("FSM COUNTER  4"); 
                
                evt = queue.get();
                if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                
                       
                    if(message->event == BUTTON_PRESS) state = STATE_5;
                    if(message->event == TIME_OUT) state = STATE_3;
                
                    mpool.free(message);
                    }
    
                timer.start(2000);
            
            break;    
            
            case STATE_5:
                lcd.cls();
                lcd.locate(0,2);
                lcd.printf("FSM COUNTER  5"); 
                
                evt = queue.get();
                if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                
                       
                    if(message->event == BUTTON_PRESS) state = STATE_5;
                    if(message->event == TIME_OUT) state = STATE_4;
                
                    mpool.free(message);
                    }
                 

                
                timer.start(2000);
            
            break; 
            
            
            
            
        }//End of switch
        
    //toggle led for local testing    
    led2= !led2;
                                       
    }//end of while(1)
    
    
}
