#include "mbed.h"
#include "rtos.h"
#include "C12832.h"
#include "MMA7660.h"

//#jtb#002 firedoor
#include "LM75B.h"



//FINITE STATE MACHINE EVENTS
#define NO_EVENT 0
#define TIME_OUT 1
#define BUTTON_PRESS 2
#define TILT 3
#define PUSH 4

//##jtb001: timeout 10secs on enter
#define TIME_OUT_10 5

//#jtb#002 firedoor
#define TEMPERATURE_HIGH 6
#define TEMPERATURE_LOW 7


//STATES
#define STATE_0 0
#define STATE_1 1
#define STATE_2 2
#define STATE_3 3
#define STATE_4 4
#define STATE_5 5
#define STATE_6 6


//#jtb#002 firedoor
#define TEMPERAURE_SETPOINT 29


//Mutex
Mutex LED_RGB;
//#jtb#002 firedoor
Mutex LCD_MUTEX;



//pass event via message queue
typedef struct {
    int    event;   /* AD result of measured voltage */
} message_t;

MemoryPool<message_t, 16> mpool;
Queue<message_t, 16> queue;

//Digital input
//DigitalIn coin(p14);
InterruptIn button(p14);

//Analog input
AnalogIn push(p19);

//Setup hardware
MMA7660 MMA(p28, p27);
C12832 lcd(p5, p7, p6, p8, p11);

//RGB LEDs
DigitalOut led_R(p23); //LED RGB red
DigitalOut led_G(p24); //LED RGB green
DigitalOut led_B(p25); //LED RGB Blue

//leds for debug
DigitalOut led4(LED4); //LED 
DigitalOut led3(LED3); //LED
DigitalOut led2(LED2); //LED

//#jtb#002 firedoor
LM75B sensor(p28,p27);
        
//Global varible
int button_press=0;

    
void timeout_event(void const *n) 
{
       
        //event via a message queue
        message_t *message = mpool.alloc();
        message->event = TIME_OUT; 
        queue.put(message);
        
        led4 =  !led4;
        
}

//##jtb001: timeout 10secs on enter
void timeout_event_10(void const *n) 
{
       
        //event via a message queue
        message_t *message = mpool.alloc();
        message->event = TIME_OUT_10; 
        queue.put(message);
        
        led3 =  !led3;
        
}


void button_event_thread(void const *argument) {
    
    while (true) {
        
        if (button_press == 1)
            {
           
            //event via a message queue
            message_t *message = mpool.alloc();
            message->event = BUTTON_PRESS; 
            queue.put(message);
            
            led3 = !led3;
            button_press = 0;
            Thread::wait(500);
            }
            
            
          
    }
}


void tilt_event_thread(void const *argument) {
    float tilt_value_Y = MMA.y();
    float tilt_value_X = MMA.x();
    while (true) 
        {
     
        //debouce delay for switch
        

        if (tilt_value_Y <= MMA.y()-0.2 ^ tilt_value_Y >= MMA.y()+0.2 )
            {

            //event via a message queue
            message_t *message = mpool.alloc();
            message->event = TILT; 
            queue.put(message);
            
            led3 = !led3;
            Thread::wait(1500);
            tilt_value_Y = MMA.y();
            }
            
        
        }
        
    
}
 
 
void push_event_thread(void const *argument) {
    float push_value = push.read();
    while (true) 
        {
     
        //debouce delay for switch
        
        if (push_value >= push.read()- 0.15 ^ push_value <= push.read()+ 0.15 )
            {
            //event via a message queue
            message_t *message = mpool.alloc();
            message->event = PUSH; 
            queue.put(message);
            led3 = !led3;
            Thread::wait(1000);
            push_value = push.read();
            }
        }
        
    
}

void flash_led_thread(void const *argument) {
    while (true) 
        {
        Thread::signal_wait(0x1);
    
        LED_RGB.lock();
        led_R=0;
        led_G=1;
        for (int i=0;i<=20;i++)
            {
            //LED_RGB.lock();
            led_R = !led_R; 
            //LED_RGB.unlock(); 
            Thread::wait(100);
            }
        //LED_RGB.lock();
        led_R = 1; 
        LED_RGB.unlock();             
        }
     
}      


 
//#jtb#002 firedoor 
void temperature_event_thread(void const *argument) {
int first_time_high = true;      
int first_time_low = true;

while (1) 
    {
    
    LCD_MUTEX.lock();
    lcd.locate(0,10);
    lcd.printf("Temp = %.3f\n", sensor.read());
    LCD_MUTEX.unlock();
    
            
    if ((sensor.read() > TEMPERAURE_SETPOINT) && first_time_high == true )
        {
        //event via a message queue
        message_t *message = mpool.alloc();
        message->event = TEMPERATURE_HIGH; 
        queue.put(message);
        led3 = !led3;
        first_time_high = false; //latch
        first_time_low = true; //latch
        //Thread::wait(1000);
        }
    else if ((sensor.read() < TEMPERAURE_SETPOINT) && first_time_low == true )
        {
        //event via a message queue
        message_t *message = mpool.alloc();
        message->event = TEMPERATURE_LOW; 
        queue.put(message);
        led3 = !led3;
        first_time_high = true; //latch
        first_time_low = false; //latch
        //Thread::wait(1000);
        
        }
    else
        {
        first_time_high = true; //latch
        first_time_low = true; //latch    
        Thread::wait(1000);
        }
        
                    

    }//end of while
   
}

void Button_Inter() {
//Flash_LED_Thread.signal_set(0x1);  

button_press=1;
    
} 
    
int main (void) {
    
//Thread fsm(fsm_thread); 
Thread button_event(button_event_thread);
Thread tilt_event(tilt_event_thread);
Thread push_event(push_event_thread);
Thread Flash_LED_Thread(flash_led_thread); 

//#jtb#002 firedoor
Thread temperature_event(temperature_event_thread);

RtosTimer timer(timeout_event, osTimerPeriodic, (void *)0);

//##jtb001: timeout 10secs on enter
RtosTimer timer_10(timeout_event_10, osTimerPeriodic, (void *)0);


//Interrupts
button.rise(&Button_Inter);

int state = STATE_0;

LED_RGB.lock();
led_R=1;
led_G=1;
led_B=1;
LED_RGB.unlock();

if (MMA.testConnection())   //setup accler

//start timer with a 2 sec timeout 
timer.start(2000); 


//start up screen
//#jtb#002 firedoor
LCD_MUTEX.lock();
lcd.cls();
lcd.locate(0,2);
lcd.printf("Insert Coin");   
LCD_MUTEX.unlock();

//lcd.locate(0,10);
//lcd.printf("Temp = %.3f\n", sensor.read());

    while (true) {
     
        
        switch(state)
            {
            case STATE_0:            
                osEvent evt = queue.get();
                if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                
                       
                    if(message->event == BUTTON_PRESS) 
                        {
                        LED_RGB.lock();
                        led_G=0; // on
                        led_R=1; // off
                        LED_RGB.unlock();
                        
                        //#jtb#002 firedoor
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Please Enter");
                        LCD_MUTEX.unlock();
                        
                        //##jtb001 start timer2 with a 10 sec timeout 
                        timer_10.start(10000); 
                        
                        state = STATE_1;
                        }

                    if(message->event == TILT) 
                        {
                        LED_RGB.lock();
                        led_G=1;
                        led_R=1;
                        LED_RGB.unlock();
                        
                        //#jtb#002 firedoor
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("STOP");
                        lcd.locate(0,10);
                        lcd.printf("Please Insert Coin"); 
                        LCD_MUTEX.unlock(); 
                        
                        Flash_LED_Thread.signal_set(0x1);                 
                        state = STATE_3;
                        timer.start(2000);
                        }      
                        
                    if(message->event == TEMPERATURE_HIGH) 
                        {
                        LED_RGB.lock();
                        led_G=0; // on
                        led_R=0; // oN
                        LED_RGB.unlock();
                        
                        //#jtb#002 firedoor
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Please Exit");
                        LCD_MUTEX.unlock();
                                                                      
                        state = STATE_6;
                        }                  

                    mpool.free(message);
                    }
                
                
            
            break;
            
            case STATE_1:
               
                evt = queue.get();
                if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                
                       
                    if(message->event == TILT) 
                        {
                        LED_RGB.lock();
                        led_G=1;
                        led_R=1;
                        LED_RGB.unlock();
                        
                        //#jtb#002 firedoor
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("STOP");
                        lcd.locate(0,10);
                        lcd.printf("Please Enter");  
                        LCD_MUTEX.unlock();
                        
                        Flash_LED_Thread.signal_set(0x1);                 
                        state = STATE_4;
                        timer.start(2000);
                        } 
                    if(message->event == PUSH)
                        {
                        LED_RGB.lock();
                        led_R=1;//off
                        led_G=0;//on
                        LED_RGB.unlock();
                        
                        //#jtb#002 firedoor
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Have a nice day");
                        LCD_MUTEX.unlock();
                        timer.start(2000);
                        state = STATE_2;
                        }
                    
                    //##jtb001: timeout 10secs on enter
                    if(message->event == TIME_OUT_10)
                        {
                        LED_RGB.lock();
                        led_R=0;
                        led_G=1;
                        LED_RGB.unlock();
                        
                        //#jtb#002 firedoor
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Insert Coin");
                        LCD_MUTEX.unlock();
                        state = STATE_0;
                        }
                                        
                    mpool.free(message);
                    }
                 
           
                
            
            break;
            
            case STATE_2:

               evt = queue.get();
               if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                
  
                    if(message->event == TILT) 
                        {
                        //#jtb#002 firedoor    
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("STOP");
                        lcd.locate(0,10);
                        lcd.printf("Please Insert Coin"); 
                        LCD_MUTEX.unlock();
                        
                         
                        state = STATE_5;
                        timer.start(2000);
                        Flash_LED_Thread.signal_set(0x1);                        
                        }
                    if(message->event == TIME_OUT)
                        {
                        LED_RGB.lock();
                        led_R=0;
                        led_G=1;
                        LED_RGB.unlock();
                        
                        //#jtb#002 firedoor
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Insert Coin");
                        LCD_MUTEX.unlock();
                        state = STATE_0;
                        
                        }
                    mpool.free(message);
                    }

                
            
            break;          
            
          case STATE_3:

               evt = queue.get();
               if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                

                    if(message->event == TIME_OUT)
                        {
                        LED_RGB.lock();
                        led_R=0;
                        led_G=1;
                        LED_RGB.unlock();
                        
                        //#jtb#002 firedoor
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Insert Coin");
                        LCD_MUTEX.unlock();
                        
                        state = STATE_0;
                        timer.start(2000);
                        }
                    mpool.free(message);
                    }

                
            
            break;     

 
          case STATE_4:

               evt = queue.get();
               if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                

                    if(message->event == TIME_OUT)
                        {
                        LED_RGB.lock();
                        led_R=1;
                        led_G=0;
                        LED_RGB.unlock();
                        
                        //#jtb#002 firedoor
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Please Enter");
                        LCD_MUTEX.unlock();
                        
                        state = STATE_1;
                        
                        }
                    mpool.free(message);
                    }

                
            
            break; 
            
         case STATE_5:

               evt = queue.get();
               if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                

                    if(message->event == TIME_OUT)
                        {
                        LED_RGB.lock();
                        led_R=1;
                        led_G=0;
                        LED_RGB.unlock();
                        
                        //#jtb#002 firedoor
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Have a nice day");
                        LCD_MUTEX.unlock();
                        
                        state = STATE_2;
                        timer.start(2000);
                        }
                    mpool.free(message);
                    }

                
            
            break; 
            
            case STATE_6:

               evt = queue.get();
               if (evt.status == osEventMessage) 
                    {
                    message_t *message = (message_t*)evt.value.p;
                

                    if(message->event == TEMPERATURE_LOW)
                        {
                        LED_RGB.lock();
                        led_R=0;
                        led_G=1;
                        LED_RGB.unlock();
                        
                        //#jtb#002 firedoor
                        LCD_MUTEX.lock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Insert Coin");
                        LCD_MUTEX.unlock();
                        
                        state = STATE_0;
                        
                        }
                    mpool.free(message);
                    }

               
            
            break; 
        }//End of switch
        
    //toggle led for local testing    
    //led2= !led2;
                                       
    }//end of while(1)
    
    
}