#include "mbed.h"
#include "Servo.h"

Servo s1(p21);
Servo s2(p22);

 
Ticker flipper;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
 
void flip() {
    led2 = !led2;
    s1 = s1+0.005;
    s2 = s2+0.005;
    
    if(s1 == 1)
        s1 = 0;
    if(s2 == 1)
        s2 =0;
}
 
int main() {
    
    led2 = 1;
    flipper.attach(&flip, 0.01); // the address of the function to be attached (flip) and the interval (2 seconds)
 
    s1.calibrate(0.00105, 45.0); 
    s2.calibrate(0.00105, 45.0);
    
    s1=0;
    s2=0;
    
    // spin in a main loop. flipper will interrupt it to call flip
    while(1) {
        led1 = !led1;
        wait(0.2);
    }
}