#include "mbed.h"
#include "rtos.h"

#include "LM75B.h"
#include "C12832.h"

Mutex speaker_mutex; 

C12832 lcd(p5, p7, p6, p8, p11);
LM75B sensor(p28,p27);
Serial pc(USBTX,USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3); 

PwmOut spkr(p26);
DigitalIn fire(p14);

void led1_thread(void const *args) {
    while (true) {
        
         //play tone on speaker
         
         //lock mutex
         /////////////////////
         speaker_mutex.lock(); 
         for (float i=2000.0; i<10000.0; i+=100) 
            {
            spkr.period(1.0/i);
            spkr=0.5;
            
            led1 = !led1;
            Thread::wait(50);
            }
          
        spkr=0.0;
        //unlock mutex
        //////////////////////
        speaker_mutex.unlock(); 
        
        //wait for user to hit fire before repeating
        while(!fire) {
            led1 = !led1;}

    }
}

void led2_thread(void const *args) {
        
    //Try to open the LM75B
    if (sensor.open()) {
        printf("Device detected!\n");
        }
        
    while (true) 
        {
        
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Temp = %.3f\n", (float)sensor.temp());
             
        //play one pulse tone for 1 second if temp high
        if((float)sensor.temp() > 26)
            {
            //lock mutex
            /////////////////////
            speaker_mutex.lock(); 
            
            spkr.period(1.0/1000);
            spkr=0.5;
         
         
            }
        else
            {

            
            //turn off after every pulse
            spkr=0.0;   
                        
            //unlock mutex
            //////////////////////
            speaker_mutex.unlock();   
            }
        
        led2 = !led2;
        Thread::wait(850);
        }
}
 
int main() {
    Thread thread1(led1_thread);
    Thread thread2(led2_thread);
    
    while (true) {
        led3 = !led3;
        Thread::wait(1100);
    }
}
