/*
 * Adafruit NeoPixel example
 *
 * This program displays a couple simple patterns on an 8x8 NeoPixel matrix.
 *
 */

#include "mbed.h"
#include "NeoStrip.h"
#include "gt.h"
#include "C12832_lcd.h"
#include "Arial_9.h"
#include "Small_7.h"


#define N 12  //number of leds
#define PATTERNS 3

Serial pc(USBTX, USBRX);
NeoStrip strip(p25, N); // DIN PIN with number of LEDs
NeoStrip led1(p25, 0); 

////////////////////////////////////
//////note colours value below//////
////////////////////////////////////

float bright = 0.20;	// 20% is plenty for indoor use
int red = 0xFF0000;
int orange = 0xFF8000;
int yellow = 0xFFFF00;
int green = 0x00FF44;
int blue = 0x00BFFF;
int indigo = 0x0F0082;
int violet = 0x8000B4;
int white = 0xFFFFFF;
int i = 0;
int hueToRGB(float h);

	
//C12832_LCD LCD("LCD"); 
//C12832_LCD lcd(p5, p7, p6, p8, p11);  //jtb

//variable that hold 1ms timer count, this can used in main to time stuff
int play_led_1ms_timer = 0;

//set up a ticker funtion
//////////////////////////////////////////////////////////////////////////

Ticker play_led_1ms_ticker;

//this funtion runs every ms and increments lay_led_1ms_timer by 1
void play_led_1ms(void)
{
play_led_1ms_timer = play_led_1ms_timer+1;

//stop overflow
if(play_led_1ms_timer> 1000000)
	{
	play_led_1ms_timer = 0;
	}
}

int main()
{
  // set up a function to play every 1.5 sec
  play_led_1ms_ticker.attach(&play_led_1ms, 0.001);
  
/////////////////////////////////////////////////////////////////////////////  
    
   strip.setBrightness(bright);	// set default brightness
   strip.clear();
   strip.write();   

	pc.printf("1 - Bootup\n\r");
	pc.printf("2 - Bootdown\n\r");
	pc.printf("3 - Clear\n\r");
	pc.printf("4 - Happy\n\r");
	pc.printf("5 - Sad\n\r");

	while(true)
	{
	if (pc.readable()) 
		{
        switch(pc.getc()) 
        	  {
              case '1'://bootup sequence
			         
                    //LCD.cls();
                    strip.clear();
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(0,red);
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(1,orange);
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(2,yellow);
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(3,green);
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(4,blue);
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(5,indigo);
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(6,violet);
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(7,indigo);
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(8,blue);
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(9,green);
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(10,yellow);
                    strip.write();
                    wait_ms(200);

                    strip.setPixel(11,orange);
                    strip.write();
                    wait_ms(200);
   
                    break;
                    
                case '2'://bootdown sequence
  
                    //LCD.cls();

                    strip.setPixel(11,orange);
                    strip.write();
                    wait_ms(1);

                    strip.setPixel(10,yellow);
                    strip.write();
                    wait_ms(1);

                    strip.setPixel(9,green);
                    strip.write();
                    wait_ms(1);

                    strip.setPixel(8,blue);
                    strip.write();
                    wait_ms(1);

                    strip.setPixel(7,indigo);
                    strip.write();
                    wait_ms(1);

                    strip.setPixel(6,violet);
                    strip.write();
                    wait_ms(1);

                    strip.setPixel(5,indigo);
                    strip.write();
                    wait_ms(1);

                    strip.setPixel(4,blue);
                    strip.write();
                    wait_ms(1);

                    strip.setPixel(3,green);
                    strip.write();
                    wait_ms(1);

                    strip.setPixel(2,yellow);
                    strip.write();
                    wait_ms(1);

                    strip.setPixel(1,orange);
                    strip.write();
                    wait_ms(1);

                    strip.setPixel(0,red);
                    strip.write();
                    wait_ms(1);
          
                    for (int i = 11; i >= 0; i--) 
                        {
                        strip.setPixel(i,0,0,0);
                        strip.write();
                        wait_ms(500);
                        }
                   
      			break;
            
                case '3'://clear
    				//LCD.cls();
    				strip.clear();
    				strip.write();
    
    			break;
    			
                case '4':

    				//LCD.claim(stdout);     
    				//LCD.locate(10,0);
    				//LCD.set_font((unsigned char*) Arial_9);
    				//printf("Happy Bot");
    				//LCD.copy_to_lcd();
    				//LCD.set_font((unsigned char*) Small_7);

                    //reset timer value to 0
                    //////////////////////////////////////
					play_led_1ms_timer= 0;
					
					//repeat do while for 2000 ms see line 247 for while part
					// this code will repeat untill play_led_1ms_timer > 2000
					do
						{		
						for (int i = 0; i < N; i++)
							{
							strip.setPixel(i,white);
	    					strip.write();
	    					wait_ms(30);
	    					}

						for (int i = 0; i < N; i++) 
						    {
                            strip.setPixel(i,yellow);
                            strip.write();
                            wait_ms(30);
                            }

                        for (int i =0; i < N; i++) 
                            {
                            strip.setPixel(i,orange);
                            strip.write();
                            wait_ms(30);
                            }
						}
					while(play_led_1ms_timer < 2000); //timer value you want here i.e 2000 2s, 3500 3.5s etc
                    
                	strip.clear();
    				strip.write();    
                        
			        break;
         	
					case '5':
	
				    	for (float j = 0; j < 0.3; j=j+0.01) //float jack float i :-) , i = i+0.01
				        	{
				        	//pc.printf("%f ",j); debug
				        	strip.setBrightness(j);
							
							//need to write to pixcel to change brightness
							for (int i = 0; i < 12; i++)
								{	
								strip.setPixel(i,blue);
	    						strip.write();
	    						wait_ms(1);
	    						} 	
        					wait_ms(200);
         					}
         				           
         	     	 	strip.clear();
    				 	strip.write(); 
    				
         			 break;        	
         		}//End of switch
         		
         }//end of if readable
         
    }//end of while(1)
    
}//end of main()
