#include "mbed.h"
#include "XBeeLib.h"
 
using namespace XBeeLib;
 
Serial pc(USBTX, USBRX);

bool capt_1;
bool capt_2;
bool capt_3;
bool capt_4;
bool capt_5;
bool capt_6;
 
/** Callback function, invoked at packet reception */
static void receive_cb(const RemoteXBeeZB& remote, bool broadcast, const uint8_t *const data, uint16_t len)
{
    const uint64_t remote_addr64 = remote.get_addr64();
 
    pc.printf("\r\nGot packet, len %d\r\nData: ", len);
 
    for (int i = 0; i < len; i++)
    {
        pc.printf("%02x ", data[i]);
    }
        
    capt_1 = data[0] >> 7;
    capt_2 = data[0] >> 6;
    capt_3 = data[0] >> 5;
    capt_4 = data[0] >> 4;
    capt_5 = data[0] >> 3;
    capt_6 = data[0] >> 2;
 
    pc.printf("\r\n");
}
 
int main()
{ 
    XBeeZB xbee = XBeeZB(p13, p14, NC, NC, NC, 9600);
 
    /* Register callbacks */
    xbee.register_receive_cb(&receive_cb);
 
    RadioStatus const radioStatus = xbee.init();
    MBED_ASSERT(radioStatus == Success);
 
    /* Wait until the device has joined the network */
    pc.printf("Waiting for device to join the network: ");
    while (!xbee.is_joined()) {
        wait_ms(1000);
    }
    pc.printf("OK\r\n");
 
    while (true) {
        xbee.process_rx_frames();
        wait_ms(100);
    }
}
