#include "Train.h"

Train::Train(const unsigned int newaddress, const unsigned int newinst, int pos, const unsigned int speed, const unsigned int speed2): normSpeed(speed), slowSpeed(speed2)
{
    //ctor
    address = newaddress;
    inst = newinst;
    position = pos;
    dirClockwise = false;
    nrPacket = 20;
    isStopped = false;

}

Train::~Train()
{
    //dtor
}

unsigned int Train::normalSpeed(){
    return normSpeed;    
}

unsigned int Train::slowlySpeed(){
    return slowSpeed;    
}

int Train::getPosition(){

    return position;
}

void Train::sendCommand(){
    //lcd.cls();
    //lcd.printf("Send command");
    //lcd.printf("%d", inst);
    DCC_send_command(address, inst, nrPacket);
        
}

void Train::changeSpeed(unsigned int speed){
    isStopped = false;
    inst = speed;    
}

void Train::Stop(){
        inst = 0x40;
        isStopped = true;
        DCC_send_command(address, inst, nrPacket);
}

unsigned int Train::getSpeed(){
    return inst;
}

void Train::setPosition(int pos){
    position = pos;    
}

bool Train::isClockwise(){
    return dirClockwise;    
}

void Train::changeDirection(){
    dirClockwise = !dirClockwise;    
}

bool Train::checkStop(){
    return isStopped;
}
    
bool Train::checkInterupt(int pos){
    switch(pos){
    case 0:
        if(position == 13 || position == 0 || position == 12)
            return true;
        break;
    case 1: 
        if(position == 0 || position == 1 || position == 13)
            return true;
        break;
    case 2: 
        if(position == 15 || position == 2)
            return true;
        break;
    case 3: 
        if(position == 14 || position == 3 || position == 2)
            return true;
        break;
    case 4: 
        if(position == 14 || position == 4 || position == 2)
            return true;
        break;
    case 5: 
        if(position == 11 || position == 6 || position == 5)
            return true;
        break;
    case 6: 
        if(position == 7 || position == 4 || position == 5 || position == 6 || position == 8)
            return true;
        break;
    case 7: 
        if(position == 8 || position == 6 || position == 7 || position == 9)
            return true;
        break;
    case 8: 
        if(position == 7 || position == 9 || position == 8 || position == 6)
            return true;
        break;
    case 9: 
        if(position == 3 || position == 9 || position == 14)
            return true;
        break;
    case 10: 
        if(position == 8 || position == 10 || position == 7)
            return true;
        break;
    case 11: 
        if(position == 5 || position == 11)
            return true;
        break;
    case 12: 
        if(position == 11 || position == 10 || position == 12)
            return true;
        break;
    case 13: 
        if(position == 12 || position == 13)
            return true;
        break;
    case 14:
        if(position == 2 || position == 14 || position == 15)
            return true;
        break;
    case 15:
        if(position == 1 || position == 15)
            return true;
        break;
    default: 
        lcd.cls();
        lcd.printf("Train not right one");
        break;
    }
    return false;
}