#include "Track.h"

Track::Track () : trackpin(p20), lcd(p22, p21, p23, p24, p25, p26), myled1(LED1)
{
    //ctor
    address = 0;
    inst = 0;
    myled1 = 1;
}

Track::~Track()
{
    //dtor
}

void Track::DCC_send_command(unsigned int address, unsigned int inst, unsigned int repeat_count)
{
    unsigned __int64 command = 0x0000000000000000; // __int64 is the 64-bit integer type
    unsigned __int64 temp_command = 0x0000000000000000;
    unsigned __int64 prefix = 0x3FFF; // 14 "1" bits needed at start
    unsigned int error = 0x00; //error byte
    //calculate error detection byte with xor
    error = address ^ inst;
    //combine packet bits in basic DCC format
    command = (prefix<<28)|(address<<19)|(inst<<10)|((error)<<1)|0x01;
    //printf("\n\r %llx \n\r",command);
    int i=0;
//repeat DCC command lots of times
    while(i < repeat_count) {
        temp_command = command;
//loops through packet bits encoding and sending out digital pulses for a DCC command
        for (int j=0; j<64; j++) {
            if((temp_command&0x8000000000000000)==0) { //test packet bit
                //send data for a "0" bit
                trackpin=0;
                wait_us(100);
                trackpin=1;
                wait_us(100);
            } else {
                //send data for a "1"bit
                trackpin=0;
                wait_us(58);
                trackpin=1;
                wait_us(58);
            }
            // next bit in packet
            temp_command = temp_command<<1;
        }
        i++;
    }
}