//
//
//                                      SISTEMA DE DETECCIÓN Y ALERTAS POR APROXIMACIÓN DE VEHÍCULOS EN 
//                                                      ZONAS CIEGAS DE UNA MOTOCICLETA
//
//                                                          JOSE ALBERTO RUIZ ORTEGA
//                                                                  1085262530
//
//                                                            INGENIERIA DE CONTROL 
//
//                                                      UNIVERSIDAD NACIONAL DE COLOMBIA
//
//                                  Programa realizado para la detección de vehiculos que se acercan a una motocicleta.
//                           Para la realización de este trabajo se contó con la colaboracion del estudiante Jair Hernán Vargas 
//                                  


//::::::::::::::::::                                               Librerías
#include "mbed.h"
#include "HCSR04.h"
#include "HCSR042.h"
#include "HCSR043.h"
#include "HCSR044.h"
#include "TextLCD.h"
#include "MMA8451Q.h"
#include "DebouncedIn.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)

//::::::::::::::::::                                              Puertos 
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
PwmOut rojo(LED_RED);
PwmOut verde(LED_GREEN);
PwmOut azul(LED_BLUE);
DigitalOut led2(PTE23);
DigitalOut led3(PTE29);
DigitalOut led4(PTC17);
DigitalOut led5(PTA16);
PwmOut ledD(PTC8);
PwmOut ledI(PTC9);
PwmOut sound(PTA12);
DigitalOut ledbD(PTC7);
DigitalOut ledbI(PTC0);
DigitalOut ledgD(PTC5);
DigitalOut ledgI(PTC6);
HCSR04 sensor(PTD4, PTA13);
HCSR042 sensor2(PTA5, PTD5);
HCSR043 sensor3(PTA1, PTD0);
HCSR044 sensor4(PTA4, PTD2);
DebouncedIn button1(PTC12);

//::::::::::::::::::::::::::::::                          Display

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); 

//::::::::::::::::::::::::::::::                          Variables

float X,Y,Z;
bool b;
bool a;
bool c;
bool d;
int e;
float DD1;
float DD2;

//:::::::::::::::::::::::::::::::::                       PROGRAMA
int main()
{
                
    while(1){
                //a=0;
                
                //b=0;
                //::::::::::::::::::::::::::            Acelerómetro
                
                
                X=acc.getAccX();
                Y=acc.getAccY();
                Z=acc.getAccZ();
                rojo=1.0 - abs(X);
                verde=1.0 - abs(Y);
                azul=1.0 - abs(Z);
                wait(0.1);
        
                if (Y>=0.1)
                {
                led2=1;
                c=1;
                d=0;
                }
                 else
                 {
                led2=0;
                c=0;
                }
                if (Y<=-0.1)
                {
                d=1;
                c=0;
                led3=1;
                }
                else
                {
                led3=0;
                d=0;
                }
                
                // ::::::::::::::::::::::::::::::::::      Selección de Modos
                
                lcd.locate(0,0);
                lcd.printf("e:%d ",e);
                wait(0.1);
                
                if (button1.falling())
                {
                    e=e+1;
                    
                }
                 if (e==3)
                {
                    e=0;
                }
                
                // MODO CARRETERA
                if (e==0)
                {
                    DD1=120;
                    DD2=400;
                    lcd.locate(0,0);
                    lcd.printf("Modo Carretera");
                    wait(0.1);
                }
                
                // MODO CIUDAD
                
                if (e==1)
                {
                    DD1=70;
                    DD2=300;
                    lcd.locate(0,1);
                    lcd.printf("Modo Ciudad");
                    wait(0.1);
                }
                
                // MODO SIN ALARMAS
                
                if (e==2)
                {
                    sound=0;
                    lcd.locate(0,1);
                    lcd.printf("Modo Sin Alarma");
                    wait(0.1);
                }
            
                    //:::::::::::::::::::::::::::::::::::::::::::::SENSADO
                    
                // SENSOR 1 DERECHA ________________________________________________________________________________________
                long d = sensor.distance(1);
                lcd.locate(0,0);
                lcd.printf("DER:%d ",sensor.distance(1));
                
                
                // SENSOR 2 IZQUIERDA ________________________________________________________________________________________
                long s = sensor2.distance(1);
                lcd.locate(8,0);
                lcd.printf("IZQ:%d ",sensor2.distance(1));
                                
                 // SENSOR 3 POSTERIOR ________________________________________________________________________________________
                long p = sensor3.distance(1);
                lcd.locate(0,1);
                lcd.printf("FRN:%d ",sensor3.distance(1));
                //wait(0.5);
                
                // SENSOR 4 FRONTAL  ________________________________________________________________________________________
                long q = sensor4.distance(1);
                lcd.locate(8,1);
                lcd.printf("TRS:%d ",sensor4.distance(1));
                //wait(0.5);  
                
                //::::::::::::::::::::::::                              ALARMAS
                
              // ::::::::::::::::::::::::::::::::ALERTA MUY CERCANA DERECHA 
              
              if (d>-1 && d<=DD1)
                {
                lcd.locate(0,0);
                lcd.printf("AMAXD ");
                ledbD=0;
                ledgD=0;
                            
                ledD.period(4.0);  // 4 second period
                //ledD.pulsewidth(0.2); // 2 second pulse (on)
                ledD.write(0.20f);  // 50% duty cycle
                //while(1);          // led flashing
                  a=1;          
                }  
                
                // ::::::::::::::::::::::::::::::::ALERTA MUY CERCANA IZQUIERDA
              if(s>-1 && s<=DD1)
                {
                lcd.locate(8,0);
                lcd.printf("AMAXI ");
                ledbI=0;
                ledgI=0;
                        
                ledI.period(6.0);  // 4 second period
                //ledI.pulsewidth(0.2); // 2 second pulse (on)
                ledI.write(0.20f);  // 50% duty cycle
                //while(1);          // led flashing  
                a=1;
                }
                
                // ::::::::::::::::::::::::::::::::ALERTA CERCANA DERECHA
                if(d>DD1 && d<=DD2)
                {
                ledD=0;
                ledbD=1;
                ledgD=0;
                a=1;
                lcd.locate(0,0);
                lcd.printf("AMIND  ");
                
                }       
                 
                // ::::::::::::::::::::::::::::::::ALERTA CERCANA IZQUIERDA
                if(s>DD1 && s<=DD2)
                {
                ledI=0;
                ledbI=1;
                ledgI=0;
                a=1;
                lcd.locate(8,0);
                lcd.printf("AMINI  ");                
                }       
                       
                                     
              // ::::::::::::::::::::::::::::::::SIN ALERTAS DERECHA
                if(d>DD2)
                {
                ledD=0;
                ledbD=0;
                ledgD=1;
                a=0;
                lcd.locate(0,0);
                lcd.printf("NOALD ");
                }
                
                //:::::::::::::::::::::::::::::::: SIN ALERTAS IZQ 
                if(s>DD2)
                {
                ledI=0;
                ledbI=0;
                ledgI=1;
                a=0;
                lcd.locate(8,0);
                lcd.printf("NOALI ");
                }
                // ::::::::::::::::::::::::::::::::    SIN ALERTAS DERECHA
                   if(d==-1)
                {
                ledD=0;
                ledbD=0;
                ledgD=1;
                a=0;
                lcd.locate(0,0);
                lcd.printf("NOALD ");
                }
                
                // ::::::::::::::::::::::::::::::::    SIN ALERTAS IZQUIERDA
                if(s==-1)
                {
                ledI=0;
                ledbI=0;
                ledgI=1;
                a=0;
                lcd.locate(8,0);
                lcd.printf("NOALI ");
                }
                
                
                // ::::::::::::::::::::::::::::::::alarma POSTERIOR 
                if (p<=100)
                {
                led4=1;        
                }  
                else
                {
                led4=0;
                }
                  
                  // ::::::::::::::::::::::::::::::::alarma POSTERIOR 
                if (q<=100)
                {
                led5=1;        
                } 
                 else
                {
                led5=0;
                }
               // :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::SONIDO
               
                if (abs(Y)>=0.1 && a==1)
                {
                   sound=1;
                   wait(0.07);
                   sound=0;
                }  
                
                
                
              }
         }                