#include "mbed.h"
#include <Pulse1.h>
#include "TextLCD.h"
#include "DebouncedIn.h"


TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); 
PulseInOut irda(PTD5);
DigitalOut led(LED1); // LED ROJO
DigitalOut led2(LED2);// LED VERDE
DigitalOut led3(LED3); // LED AZUL
AnalogOut Vout(PTE30); // SALIDA SONIDO

int header =0; // Tiempo Cabecera
const int head_H = 9120; //+10% OSCILOSCOPIO 
const int head_L = 8939;//-10%  OSCILOSCOPIO 
const int Tp=300;
int i=0;
const int T_alto=1630;
const int T_bajo=533;
const int num_bits = 24;
int num[num_bits];


// TECLAS PROGRAMADAS 

int Tecla=0;
const int T1=102;
const int T2=94;
const int T3=90;
const int T4=82;
const int T5=150;
const int T6=84;


int dato; // tiempo de cada dato que se lee
  
int main()
{
      
      led=1;
      led2=1;
      led3=1;       
while(1)
    {
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("ESPERANDO ORDEN");
            
            
          
ini1: fflush( stdin );
      header=0;
      header = irda.read_low_us();   
      if (header > head_L && header < head_H) goto seguir;
      else goto ini1;
      
seguir:

      wait_us(4500);
      lcd.cls();
      Tecla=0;
      for(i=0;i<(num_bits-1);++i)
      { 
        dato = irda.read_high_us(); 
        num[i]=dato;
        wait_us(Tp);   
      }
      wait(0.3); 
 
      for(i=0;i<(num_bits-1);++i)
      {  
        
        if(num[i] > ((T_alto+T_bajo)/2))
            {
                    Tecla=Tecla+ (2^(i));
            }     
      }
      if(Tecla==T1)
      {     led=!led;
            lcd.cls();
            lcd.printf("A: ON RIGHT"); 
            lcd.locate(0,1);
            lcd.printf("Codigo=%d",Tecla);
            wait(1.5);
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("HH:%d",head_H);
            lcd.locate(8,0);
            lcd.printf("Tby:%d",Tp);
            lcd.locate(0,1);
            lcd.printf("HL:%d",head_L);
            lcd.locate(8,1);
            lcd.printf("Nby:%d",num_bits);
            wait(1.5);
            Tecla=0;
      }
      if(Tecla==T2)
      {
            led2=!led2;
            lcd.cls();
            lcd.printf("B: STOP");  
            lcd.locate(0,1);
            lcd.printf("Codigo=%d",Tecla);
            wait(1.5);
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("HH:%d",head_H);
            lcd.locate(8,0);
            lcd.printf("Tby:%d",Tp);
            lcd.locate(0,1);
            lcd.printf("HL:%d",head_L);
            lcd.locate(8,1);
            lcd.printf("Nby:%d",num_bits);      
            Tecla=0; 
            wait(1.5);
      }
      if(Tecla==T3)
      {
            
            led3=!led3;
            lcd.cls();
            lcd.printf("C: ON LEFT");
            lcd.locate(0,1);
            lcd.printf("Codigo=%d",Tecla);
            wait(1.5);
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("HH:%d",head_H);
            lcd.locate(8,0);
            lcd.printf("Tby:%d",Tp);
            lcd.locate(0,1);
            lcd.printf("HL:%d",head_L);
            lcd.locate(8,1);
            lcd.printf("Nby:%d",num_bits);
            Tecla=0; 
            wait(1.5);      
      }
            if(Tecla==T4)
      {
            
        Vout=2.5;
        wait(0.2);
        Vout=0;
            lcd.cls();
            lcd.printf("D:Boton otra func");
            lcd.locate(0,1);
            lcd.printf("Codigo=%d",Tecla);
            wait(1.5);
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("HH:%d",head_H);
            lcd.locate(8,0);
            lcd.printf("Tby:%d",Tp);
            lcd.locate(0,1);
            lcd.printf("HL:%d",head_L);
            lcd.locate(8,1);
            lcd.printf("Nby:%d",num_bits);
            Tecla=0; 
            wait(1.5);      
      }
      
                if(Tecla==T5)
      {
      Vout=2.5;
    wait(0.07);
    Vout=0;
     wait(0.03);
    Vout=2.5;
    wait(0.07);
    Vout=0;
      wait(0.03);
    Vout=2.5;
    wait(0.07);
    Vout=0;
            led2=!led2;
            lcd.cls();
            lcd.printf("ENCENDER 1");
            lcd.locate(0,1);
            lcd.printf("Codigo=%d",Tecla);
            wait(1.5);
            lcd.cls();
    
      }
      
                      if(Tecla==T6)
      {
      Vout=2.5;
    wait(0.07);
    Vout=0;
     wait(0.03);
    Vout=2.5;
    wait(0.07);
    Vout=0;
      
            led3=!led3;
            lcd.cls();
            lcd.printf("ENCENDER 2");
            lcd.locate(0,1);
            lcd.printf("Codigo=%d",Tecla);
            wait(1.5);
            lcd.cls();
            
      }
      if ((Tecla!=T3)&&(Tecla!=T2)&&(Tecla!=T1)&&(Tecla!=0)&&(Tecla!=T4)&&(Tecla!=T5)&&(Tecla!=T6)){ 
      lcd.cls();
      lcd.printf("SIN FUNCION");
      lcd.locate(0,1);
      lcd.printf("Codigo=%d",Tecla);
      wait(2);
      lcd.cls();
      lcd.locate(0,0);
      lcd.printf("HH:%d",head_H);
      lcd.locate(8,0);
      lcd.printf("Tby:%d",Tp);
      lcd.locate(0,1);
      lcd.printf("HL:%d",head_L);
      lcd.locate(8,1);
      lcd.printf("Nby:%d",num_bits);
      Tecla=0; 
      wait(1.5);}
    }
}