


#ifndef GCODE_H
#define GCODE_H
#include <string>
using std::string;
#include<stdlib.h>
#include"mbed.h"

// Object to represent a Gcode command
class Gcode {
    public:
        Gcode(const string&, Serial*);
        Gcode(const Gcode& to_copy);
        
        Gcode& operator= (const Gcode& to_copy);

        bool   has_letter ( char letter );
        float  get_float  ( char letter );
 //       float  get_double ( char letter );
        int    get_int    ( char letter );
        int    get_num_args();
        
        void   prepare_cached_values();
        void   mark_as_taken();
        
        string command;     
           
        bool has_m;
        bool has_g;
        unsigned int m;
        unsigned int g;
        Serial *stream;  
            
        bool add_nl;
        string txt_after_ok;
        bool accepted_by_module;
        float millimeters_of_travel;
};
#endif
