#include"Gcode.h"
#include <string>
using std::string;
#include"mbed.h"
Gcode::Gcode(const string& command, Serial* stream):command(command),m(0),g(0),stream(stream),add_nl(false)
{
    prepare_cached_values();
    this->millimeters_of_travel = 0.0F;
    this->accepted_by_module = false;
}

Gcode::Gcode(const Gcode& to_copy)
{
    
    this->command.assign( to_copy.command );
    this->millimeters_of_travel = to_copy.millimeters_of_travel;
    this->has_m                 = to_copy.has_m;
    this->has_g                 = to_copy.has_g;
    this->m                     = to_copy.m;
    this->g                     = to_copy.g;
    this->add_nl                = to_copy.add_nl;
    this->stream                = to_copy.stream;
    this->accepted_by_module=false;
    this->txt_after_ok.assign( to_copy.txt_after_ok );
    
}

Gcode& Gcode::operator=(const Gcode& to_copy)
{
    if(this != &to_copy)
    {
        this->command.assign( to_copy.command );
        this->millimeters_of_travel = to_copy.millimeters_of_travel;
        this->has_m                 = to_copy.has_m;
        this->has_g                 = to_copy.has_g;
        this->m                     = to_copy.m;
        this->g                     = to_copy.g;
        this->add_nl                = to_copy.add_nl;
        this->stream                = to_copy.stream;
        this->txt_after_ok.assign( to_copy.txt_after_ok );
    }    
    this->accepted_by_module = false;
    return *this;
}



bool Gcode::has_letter(char letter)
{
    for(std::string::iterator c = this->command.begin(); c != this->command.end(); c++)      //iterator  const_iterator not support  why?
    {
        if(*c == letter)
        {
            return true; 
        }  
    }
    
    return false;
}

// 
float Gcode::get_float(char letter)
{
        
    
}
void Gcode::prepare_cached_values(){


}
