#include "mbed.h"
#include "SerialBuffered.h"

Serial loggerSerial(USBTX, USBRX);

// run this with p13 joined to p14 to test the SerialBuffered class 

int main() {

   SerialBuffered *b = new SerialBuffered( 1001, p13, p14);
   
   b->baud( 112500 );
   b->setTimeout( 0.1 );
   
    // write a bufferful   
   for( int i = 0; i < 1000; i ++ )
   {
       b->putc( i % 0xff );
   }
   
   // and check it all arrived
   for( int i = 0; i < 1000; i ++ )
   {
       uint8_t j = b->getc();
       if( j != i % 0xff )
       {
           loggerSerial.printf("Bad byte %x at %x\r\n", j, i );
           break;
       }
       
   }
    
   // write another bufferful 
   for( int i = 0; i < 1000; i ++ )
   {
       b->putc( i % 0xff );
   }
   
   // and check it arrived too, to confirm the circular buffer is working
   for( int i = 0; i < 1000; i ++ )
   {
       uint8_t j = b->getc();
       if( j != i % 0xff )
       {
           loggerSerial.printf("Bad byte %x at %x\r\n", j, i );
           break;
       }
   }
   
    // write another bufferful, deliberately short
   for( int i = 0; i < 999; i ++ )
   {
       b->putc( i % 0xff );
   }


   // and read it back with readBytes   
   b->setTimeout( 5 ); // set a long timeout so we can see we are waiting for it


   uint8_t *buff = (uint8_t*) malloc( 1000 );
   int nRead = b->readBytes( buff, 1000 );
   
   loggerSerial.printf("readBytes got %d\r\n", nRead );       
   
   loggerSerial.printf("Done\r\n");    
}
