#include "mbed.h"
#include "RF12B.h"
#include "DS1820.h"
#include "Ticker.h"
#include "time.h"

//#define USE_RF12
//#define USE_RTC

//-----------------------------------------------------------------------------
#ifdef USE_RF12
RF12B rfm12b(PB_4, PB_5, PB_3, PA_8, PA_10); // sdi, sdo, sclk, ncs, nirq
#endif
Ticker tick1;
DigitalOut led1(LED1);

const int MAX_PROBES = 4;
DS1820* probe[MAX_PROBES];
float temp[MAX_PROBES];

//-----------------------------------------------------------------------------
void tick()
{
    led1 = !led1;
    printf("tick\n");
}

//-----------------------------------------------------------------------------
int search_ds1820()
{
    int i;
    int found=0;

    // Initialize the probe array to DS1820 objects
    for (i = 0; i < MAX_PROBES; i++)
        probe[i] = new DS1820(PA_3);

    // Initialize global state variables
    probe[0]->search_ROM_setup();
    
    // Loop to find all devices on the data line
    while (probe[found]->search_ROM() && found < (MAX_PROBES-1))
        found++;
        
    // If maximum number of probes are found, 
    // bump the counter to include the last array entry
    if (probe[found]->ROM[0] != 0xFF)
        found++;
        
    return found;
}

//-----------------------------------------------------------------------------
int main() 
{
    int dsCount;
    int counter = 0;
    
    // init RTC
    //
#ifdef USE_RTC
    struct tm  clock;
    clock.tm_year = 2015;
    clock.tm_mon = 7;
    clock.tm_mday = 12;
    clock.tm_hour = 12;
    clock.tm_min = 00;
 
    set_time(mktime(&clock));
#endif

    dsCount = search_ds1820();
    printf("sensors: %d\n", dsCount);
    
    tick1.attach(&tick, 2.0);
#ifdef USE_RF12
    rfm12b.init(2, RF12_868MHZ, 5);   //id = 2, band 868, group 5
    rfm12b.rf12_recvStart();
#endif
    while(1) {
        wait(4.0);

#ifdef USE_RTC        
        time_t seconds = time(NULL);
        char tstr[16];
        
        strftime(tstr, 16, "%d/%m %H:%M:%S", localtime(&seconds));
        printf("%s", tstr);
#endif
        for (int i=0; i<dsCount; i++) {
            probe[i]->convert_temperature(DS1820::all_devices);
            temp[i] = probe[i]->temperature();
        }
             
#ifdef USE_RF12           
        rfm12b.sendStart(0, &temp, sizeof(temp));
#endif
        printf("m %d %f %f 0.0 0.0\n", counter, temp[0], temp[1]);
    }
}
