//Libraries

#include "mbed.h"
#include "QEI.h"
#include "Motor.h"


//Definitions
#define PI       3.14159265358979323846

Serial pc(USBTX, USBRX);

//Use X2 encoding by default.
QEI wheel (p17, p18, NC, 1600);  //STUDENTS NEED TO PUT THEIR OWN PINS IN THIS LINE!!!
DigitalOut mbedLED(LED1);  //use this when controller is working
DigitalOut NXPLED(LED2); //use this when you are firing
Motor turret_motor(p21, p22, p5); // pwm, fwd, rev   //STUDENTS NEED TO PUT THEIR OWN PINS IN THIS LINE!!!

DigitalOut Spinner(p23); //spinner motor  //STUDENTS NEED TO PUT THEIR OWN PINS IN THIS LINE!!!
DigitalOut Pusher(p24); // pusher motor   //STUDENTS NEED TO PUT THEIR OWN PINS IN THIS LINE!!!

// you need a timer function and a ticker function to make sure you execute the controller on a periodic basis.
// the timer lets you know when you have settled the turret
Timer t;
Ticker mytick;

//lots of variable declarations
float theta=0.0;
float theta_des = 0.0;// Placeholder for the Centroid of your target
float signal=0.0;
int num = 0;
int i = 0;
int idx = 0;  //counter for derivative filter
int k = 0; //counter for integral filter
float err = 0.0; //current error
float dc = 0.0; //duty cycle
float int_err = 0.0; //the error integral
float der_err_array[20]; //this array stores 20 values of the error derivative
float der_err = 0.0; //the filtered error derivative
float e_dot = 0.0; //the instantaneous error derivative
float old_err = 0.0; //previous error value
// define your gain values
float Kp = 0.6353;//.38; STUDENTS NEED TO PUT THEIR OWN GAIN IN THIS LINE!!!
float Ki = 0.2093;//.07; //STUDENTS NEED TO PUT THEIR OWN GAIN IN THIS LINE!!!
float Kd = 0.0961;//.000014509; //STUDENTS NEED TO PUT THEIR OWN GAIN IN THIS LINE!!!

float old_theta = 0.0; //previous value of your position theta
float omega = 0.0; //instantaneous velocity of your turret
int first = 0; //counter to help with error derivative
//float Ts = 10;
int num_shots = 7;  // STUDENTS NEED TO UPDATE THEIR NUMBER OF SHOT VALUES BASED ON BALLISTICS ANALYSIS
float ts = 0.0;

void InputCommand()  // Ticker function
{
    theta = -1.0*wheel.getPulses()*3.141592/(1600.0); //get the position of your turret
    omega = theta - old_theta/0.01;  //compute the turret instanteous velocity
    err = theta_des-theta; //compute your error

    //compute the integral of the error - use trapezoidal integration
    if (k == 0) {
        int_err = 0.0;
    } //first time step so no integral error
    else {
        int_err = int_err + old_err*0.01 + 0.5*(err-old_err)*0.01;
    }

    //compute the derivative of the error
    e_dot = (err-old_err)/0.01; // instantaneous error derivative

    //Velocity filter for derivative term
    if (idx <= 19) {
        der_err_array[idx] = e_dot;  //store values in the array
        idx = idx+1;
    } else {
        idx = 0; //start over with first entry (rewrite old values)
        der_err_array[idx] = e_dot;
        idx = idx+1;
        first = 1; //set the value of first to 1 since it is overwriting the array
    }
    if (first == 0) { //checks to see if the first time array is populated
        if (idx >=1) {
            der_err = 0.0;
            for (i=0; i<=idx; i++) {
                der_err = der_err + der_err_array[i];
            }
            der_err = der_err/idx;  //average the values in the array
        } else
            der_err = der_err_array[idx];
    } else

        for (i=0; i<=19; i++) {
            der_err = der_err + der_err_array[i];
        }
    der_err = der_err/idx;

// Compute the duty cycle
    dc = Kp*err + Ki*int_err + Kd*der_err;
    if (dc > 1.0)
        dc = 1.0;
    else if (dc < -1.0)
        dc = -1.0;
    //if(dc < 0.0)
       // dc=-0.6;

    turret_motor.speed(dc);  //send the duty cycle and direction to your turret

    //age your variables
    old_err = err;
    old_theta = theta;
    k = 1; //counter for integral error
}





int main()
{
    pc.baud(9600);
    

//Initialize PWM for motor
    turret_motor.speed(0.0);

//Input desired position - this is where you want your turret to point (units are radians)
    pc.scanf("%f,%d",&theta_des,&num_shots);
    //theta_des = 45*3.141592/(180.0);  //45 degrees - EVENTUALLY THIS WILL BE THE CENTROID OF YOUR TARGET 

//Get an initial location of your turret
    theta = -1.0*wheel.getPulses()*3.141592/(1600.0);

//compute your position error
    err = theta_des-theta;

//start the ticker and timer
    t.start();
    mytick.attach(&InputCommand, 0.01); // the address of the function to be attached (InputCommand) and the interval (0.01 seconds)

// Execute this loop to continue to move your turret while the error is greater than your desired/allowable error
    while((abs(err) > 0.02) ) { //&& (t.read() < 10.0)
        //if (abs(omega) > 0.1) {
        mbedLED = -mbedLED; //blink an LED so that you know the program is running
        pc.printf("time = %.2f (sec), theta = %0.4f (rad), Int Err = %0.4f, Der Err =%0.4f, Err = %0.4f, dc = %0.4f. \n\r",t.read(),theta, int_err, der_err,err, dc);
    }
    
    
    
    pc.printf("\r Time to fire!");
    // now it's time to fire the gun!
    //turret_motor.speed(0.0);
    
    wait(1.0);
    Spinner = 1; //turn spinner motor on
    wait(2.5);
    Pusher = 1; //turn pusher motor on
    NXPLED = 1;
    wait(0.2*num_shots); //wait to get off all shots
    Spinner = 0; //turn spinner motor off
    Pusher = 0; //turn pusher motor off
    pc.printf("time = %.2f (sec), theta = %0.4f (rad), omega = %0.4f, err = %0.4f, dc = %0.4f. \n\r",t.read(),theta, omega, err, dc);
    mytick.detach(); //turn off ticker function
    pc.printf("%f,%f\n",err,ts);
    turret_motor.speed(0.0);
    pc.printf("\rDone");


}