#include "mbed.h"
#include "potensyon.h"
#include "rtos.h"

#define h 3600
#define hani 4
#define fr 2
#define fb 1
#define syokikaku 1770

BusIn touch(dp4,dp28);
AnalogIn ain1(dp13);
AnalogIn ain2(dp9);
BusOut motor1(dp10,dp14,dp11);
BusOut motor2(dp15,dp17,dp16);
//BusOut motor[2] = {BusOut(dp10,dp14,dp11),BusOut(dp15,dp17,dp16)};
SPISlave device(dp2,dp1,dp6,dp25);
potensyon poten1(&ain1);
DigitalOut denji(dp26); 
PwmOut pwmPin(dp24);
Timer m;

void rotation(BusOut &r , int seigyo)
{
    r = 0;
    wait_ms(1);
    if(seigyo == 4)pwmPin = 1;
    else pwmPin = 0.8;
    r = seigyo;
}

int main()
{
    int data = 0;
    int flagkaku = 0;
    double kaku = 0;  
    double k = 0;  
    device.format(16,3);
    device.frequency(400000);
    
    poten1 = h;
    pwmPin.period(0.02);
    pwmPin = 0.8f;
    motor1 = 0;
    motor2 = 4;
    denji = 1;
    device.reply(10);
    while (1)  
    {    
        if(device.receive()) 
        {   
            data = device.read();
        }
        if(flagkaku == 0)
        {
            if(data >= 130 && data <= 190)
            {
                kaku = (syokikaku + 30) - ((data-130)*20);
                flagkaku = 1;
            }
        }
        k = poten1.angle();
        if(flagkaku == 1 || flagkaku == 2)
        {
            if(kaku + hani > k && kaku - hani < k)
            {
                if(flagkaku == 2)
                    flagkaku = 0;     
                rotation(motor2,4); 
                if(flagkaku == 1){
                    denji = 0;                
                    wait_ms(1000);
                    denji = 1;
                    kaku = syokikaku;
                    flagkaku = 2;
                    }  
            }
            if(kaku + hani < k)
            {
                rotation(motor2,fr);
            } 
            if(kaku - hani > k)
            {
                rotation(motor2,fb);
            } 
        }
        data = 0;
        wait_ms(10);
    }
}
